/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FilesystemProviderMetdataResolverTest {
    ProviderMetadataResolver resolver;
    Resource file;

    @BeforeMethod
    public void initTests() throws Exception {
        this.file = new ClassPathResource("/net/shibboleth/idp/oidc/metadata/impl/openid-configuration.json");
        this.resolver = new FilesystemProviderMetadataResolver(this.file);
        ((FilesystemProviderMetadataResolver)this.resolver).setId("mockId");
        ((FilesystemProviderMetadataResolver)this.resolver).initialize();
    }

    @Test
    public void testNotFound() throws Exception {
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)this.resolver.resolveSingle((Object)this.initMockWithRpId("not_found"));
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void testSuccess() throws Exception {
        String issuer = "http://idp.example.org";
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)this.resolver.resolveSingle((Object)this.initMockWithRpId("http://idp.example.org"));
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((String)metadata.getIssuer().getValue(), (String)"http://idp.example.org");
    }

    protected ProfileRequestContext initMockWithRpId(String id) {
        ProfileRequestContext profileRequestContext = new ProfileRequestContext();
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class, true);
        RelyingPartyConfiguration configuration = (RelyingPartyConfiguration)Mockito.mock(RelyingPartyConfiguration.class);
        Mockito.when((Object)configuration.getResponderId(profileRequestContext)).thenReturn((Object)id);
        rpCtx.setConfiguration(configuration);
        return profileRequestContext;
    }
}

