/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.OIDCUserInfoRequestDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCUserInfoRequestDecoderTest {
    private MockHttpServletRequest httpRequest;
    private OIDCUserInfoRequestDecoder decoder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod(HTTPRequest.Method.POST.toString());
        this.decoder = new OIDCUserInfoRequestDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidJson() throws MessageDecodingException {
        this.httpRequest.setContent("\"test\" : \"test\" }".getBytes());
        this.httpRequest.setContentType("application/json");
        this.decoder.decode();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException, IOException {
        this.httpRequest.addHeader("Authorization", (Object)"Bearer SlAV32hkKG");
        this.httpRequest.setContentType("application/x-www-form-urlencoded");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        UserInfoRequest message = (UserInfoRequest)messageContext.getMessage();
        Assert.assertEquals((String)message.getAccessToken().getValue(), (String)"SlAV32hkKG");
    }
}

