/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ClientInfoScopeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseTypeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedScopeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateScope
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateScope.class);
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Scope> requestedScopeLookupStrategy = new DefaultRequestedScopeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Scope> allowedScopeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;

    public ValidateScope() {
        this.relyingPartyIdLookupStrategy = new RelyingPartyIdLookupFunction();
        this.allowedScopeLookupStrategy = new ClientInfoScopeLookupFunction().compose((Function)new DefaultOIDCMetadataContextLookupFunction());
        this.tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying party ID lookup strategy cannot be null");
    }

    public void setRequestedScopeLookupStrategy(@Nullable Function<ProfileRequestContext, Scope> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestedScopeLookupStrategy = strategy;
    }

    public void setAllowedScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.allowedScopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Allowed scope lookyp strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;
        ResponseType responseType;
        Scope requestedScopes;
        String clientId = this.relyingPartyIdLookupStrategy.apply(profileRequestContext);
        Scope allowedScopes = this.allowedScopeLookupStrategy.apply(profileRequestContext);
        if (allowedScopes == null || allowedScopes.isEmpty()) {
            this.log.debug("{} No allowed scope for client {}, nothing to do", (Object)this.getLogPrefix(), (Object)clientId);
            return;
        }
        Scope previouslyGrantedScopes = null;
        if (this.getOidcResponseContext().getAuthorizationGrantClaimsSet() != null) {
            previouslyGrantedScopes = this.getOidcResponseContext().getAuthorizationGrantClaimsSet().getScope();
        }
        Scope scope = requestedScopes = this.requestedScopeLookupStrategy != null ? this.requestedScopeLookupStrategy.apply(profileRequestContext) : null;
        if (requestedScopes == null) {
            requestedScopes = previouslyGrantedScopes;
            previouslyGrantedScopes = null;
        }
        boolean reducedRequestedScopes = false;
        Iterator i = requestedScopes.iterator();
        while (i.hasNext()) {
            Scope.Value scope2 = (Scope.Value)i.next();
            if (!allowedScopes.contains((Object)scope2)) {
                this.log.warn("{} Removing requested but unregistered scope {} for RP {}", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
                i.remove();
                continue;
            }
            if (previouslyGrantedScopes == null || previouslyGrantedScopes.contains((Object)scope2)) continue;
            this.log.warn("{} Removing requested but previously ungranted scope {} for RP {}", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
            i.remove();
            reducedRequestedScopes = true;
        }
        if (requestedScopes.contains((Object)OIDCScopeValue.OFFLINE_ACCESS) && (responseType = (ResponseType)new DefaultRequestResponseTypeLookupFunction().apply(profileRequestContext)) != null && !responseType.contains((Object)ResponseType.Value.CODE)) {
            requestedScopes.remove((Object)OIDCScopeValue.OFFLINE_ACCESS);
        }
        if (!requestedScopes.isEmpty()) {
            this.getOidcResponseContext().setScope(requestedScopes);
        }
        if (reducedRequestedScopes && (tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext)) != null) {
            this.log.debug("{} Removing grant-encoded attributes due to reduction of requested scopes", (Object)this.getLogPrefix());
            tokenClaimsCtx.getParent().removeSubcontext((BaseContext)tokenClaimsCtx);
        }
    }
}

