/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.config.navigate.ForceAuthnProfileConfigPredicate;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestLoginHintLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestMaxAgeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedPromptLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeAuthenticationContext
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Prompt> promptLookupStrategy = new DefaultRequestedPromptLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> loginHintLookupStrategy = new DefaultRequestLoginHintLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> maxAgeLookupStrategy = new DefaultRequestMaxAgeLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = new ForceAuthnProfileConfigPredicate();

    public void setPromptLookupStrategy(@Nonnull Function<ProfileRequestContext, Prompt> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.promptLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PromptLookupStrategy lookup strategy cannot be null");
    }

    public void setLoginHintLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginHintLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LoginHintLookupStrategy lookup strategy cannot be null");
    }

    public void setMaxAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MaxAgeLookupStrategy lookup strategy cannot be null");
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String loginHint;
        Prompt prompt;
        this.log.debug("{} Initializing authentication context", (Object)this.getLogPrefix());
        AuthenticationContext authnCtx = new AuthenticationContext();
        Duration maxAge = this.maxAgeLookupStrategy.apply(profileRequestContext);
        if (maxAge != null) {
            if (maxAge.isZero()) {
                authnCtx.setMaxAge(Duration.ofSeconds(1L));
            } else {
                authnCtx.setMaxAge(maxAge);
            }
        }
        if ((prompt = this.promptLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setIsPassive(prompt.contains((Object)Prompt.Type.NONE));
            authnCtx.setForceAuthn(prompt.contains((Object)Prompt.Type.LOGIN));
        }
        if (!authnCtx.isForceAuthn()) {
            authnCtx.setForceAuthn(this.forceAuthnPredicate.test(profileRequestContext));
        }
        if ((loginHint = this.loginHintLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setHintedName(loginHint);
        }
        profileRequestContext.addSubcontext((BaseContext)authnCtx, true);
        this.log.debug("{} Created authentication context: {}", (Object)this.getLogPrefix(), (Object)authnCtx);
    }
}

