/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseModeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestResponseTypeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestStateLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ValidatedRedirectURILookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractBuildErrorResponseFromEvent;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.oidc.profile.config.logic.IncludeIssuerInAuthenticationResponsePredicate;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildAuthenticationErrorResponseFromEvent
extends AbstractBuildErrorResponseFromEvent<AuthenticationErrorResponse> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BuildAuthenticationErrorResponseFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> includeIssuerInResponsePredicate = new IncludeIssuerInAuthenticationResponsePredicate();
    private Issuer issuer;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setIncludeIssuerInResponsePredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.includeIssuerInResponsePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Include issuer in response predicate cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.includeIssuerInResponsePredicate.test(profileRequestContext)) {
            String issValue = this.issuerLookupStrategy.apply(profileRequestContext);
            if (StringSupport.trimOrNull((String)issValue) == null) {
                this.log.error("{} Could not resolve value for issuer even though it's required", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
                return false;
            }
            this.issuer = new Issuer(issValue);
        } else {
            this.issuer = null;
        }
        return true;
    }

    @Override
    protected AuthenticationErrorResponse buildErrorResponse(ErrorObject error, ProfileRequestContext profileRequestContext) {
        URI redirectURI = new ValidatedRedirectURILookupFunction().apply(profileRequestContext);
        if (redirectURI == null) {
            return null;
        }
        ResponseMode defaultResponseMode = (ResponseMode)new DefaultRequestResponseModeLookupFunction().apply(profileRequestContext);
        ResponseType responseType = (ResponseType)new DefaultRequestResponseTypeLookupFunction().apply(profileRequestContext);
        ResponseMode responseMode = responseType != null && (responseType.impliesHybridFlow() || responseType.impliesImplicitFlow()) ? (defaultResponseMode == null ? ResponseMode.FRAGMENT : (defaultResponseMode == ResponseMode.QUERY ? ResponseMode.FRAGMENT : defaultResponseMode)) : defaultResponseMode;
        return new AuthenticationErrorResponse(redirectURI, error, (State)new DefaultRequestStateLookupFunction().apply(profileRequestContext), this.issuer, responseMode);
    }
}

