/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.GrantType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.profile.config.logic.AuthorizationCodeFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.logic.ImplicitFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.logic.RefreshTokensEnabledPredicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddGrantTypeToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddGrantTypeToClientMetadata.class);
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationCodeFlowPredicate = new AuthorizationCodeFlowEnabledPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> implicitFlowPredicate = new ImplicitFlowEnabledPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensPredicate = new RefreshTokensEnabledPredicate();
    @Nonnull
    private Map<GrantType, Predicate<ProfileRequestContext>> supportedGrantTypes;

    protected void doInitialize() throws ComponentInitializationException {
        this.supportedGrantTypes = new HashMap<GrantType, Predicate<ProfileRequestContext>>();
        this.supportedGrantTypes.put(GrantType.AUTHORIZATION_CODE, this.authorizationCodeFlowPredicate);
        this.supportedGrantTypes.put(GrantType.IMPLICIT, this.implicitFlowPredicate);
        this.supportedGrantTypes.put(GrantType.REFRESH_TOKEN, this.refreshTokensPredicate);
    }

    public Predicate<ProfileRequestContext> getAuthorizationCodeFlowEnabled() {
        return this.authorizationCodeFlowPredicate;
    }

    public void setAuthorizationCodeFlowEnabled(Predicate<ProfileRequestContext> predicate) {
        this.authorizationCodeFlowPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to indicate whether authorization code flow is supported cannot be null");
    }

    public Predicate<ProfileRequestContext> getImplicitFlowEnabled() {
        return this.implicitFlowPredicate;
    }

    public void setImplicitFlowEnabled(Predicate<ProfileRequestContext> predicate) {
        this.implicitFlowPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to indicate whether hybrid flow is supported cannot be null");
    }

    public Predicate<ProfileRequestContext> getRefreshTokensEnabled() {
        return this.refreshTokensPredicate;
    }

    public void setRefreshTokensEnabled(Predicate<ProfileRequestContext> predicate) {
        this.refreshTokensPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to indicate whether refresh tokens are supported cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set grantTypes = this.getInputMetadata().getGrantTypes();
        this.log.trace("{} Requested grant types: {}", (Object)this.getLogPrefix(), (Object)grantTypes);
        HashSet<GrantType> resultTypes = new HashSet<GrantType>();
        if (grantTypes == null || grantTypes.isEmpty()) {
            this.log.debug("{} No requested grant types, adding the default set", (Object)this.getLogPrefix());
            for (GrantType grantType : this.supportedGrantTypes.keySet()) {
                this.addGrantTypeIfEnabled(resultTypes, grantType, this.supportedGrantTypes.get(grantType), profileRequestContext);
            }
        } else {
            for (GrantType grantType : grantTypes) {
                if (this.supportedGrantTypes.keySet().contains(grantType)) {
                    this.addGrantTypeIfEnabled(resultTypes, grantType, this.supportedGrantTypes.get(grantType), profileRequestContext);
                    continue;
                }
                this.log.warn("{} Ignoring unsupported requested grant type {}", (Object)this.getLogPrefix(), (Object)grantType);
            }
            if (resultTypes.isEmpty()) {
                this.log.error("{} No supported grant types requested", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        this.getOutputMetadata().setGrantTypes(resultTypes);
    }

    protected void addGrantTypeIfEnabled(Set<GrantType> resultTypes, GrantType grantType, Predicate<ProfileRequestContext> predicate, ProfileRequestContext profileRequestContext) {
        if (predicate.test(profileRequestContext)) {
            this.log.debug("{} Adding {} to the list of enabled types", (Object)this.getLogPrefix(), (Object)grantType);
            resultTypes.add(grantType);
        } else {
            this.log.debug("{} Grant type {} is not enabled", (Object)this.getLogPrefix(), (Object)grantType);
        }
    }
}

