/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCAuthenticationResponseAction
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationResponseAction.class);
    @Nonnull
    private OIDCAuthenticationResponseContext oidcResponseContext;
    @Nonnull
    private OIDCMetadataContext oidcMetadataContext;

    @Nonnull
    public OIDCAuthenticationResponseContext getOidcResponseContext() {
        return this.oidcResponseContext;
    }

    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.error("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcResponseContext = (OIDCAuthenticationResponseContext)outboundMessageCtx.getSubcontext(OIDCAuthenticationResponseContext.class);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        return true;
    }
}

