/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAccessTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAccessTokenToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenContext> accessTokenContextLookupStrategy = new ChildContextLookup(AccessTokenContext.class).compose(new ChildContextLookup(OIDCAuthenticationResponseContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nullable
    private AccessTokenContext tokenCtx;

    public void setAccessTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.tokenCtx = this.accessTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.tokenCtx == null) {
            this.log.error("{} AccessTokenContext is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.tokenCtx.getJWT() == null && this.tokenCtx.getOpaque() == null) {
            this.log.debug("{} Access token is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String token = this.tokenCtx.getJWT() != null ? this.tokenCtx.getJWT().serialize() : this.tokenCtx.getOpaque();
        this.getOidcResponseContext().setAccessToken(token, this.tokenCtx.getLifetime(), this.getOidcResponseContext().getScope());
    }
}

