/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.cli;

import com.beust.jcommander.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractCommandLineArguments;

public class ClientManagementArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"-c", "--clientId"}, required=true, description="Client ID to query or destroy")
    @Nullable
    private String clientId;

    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        if (this.getPath() == null) {
            builder.append("/profile/admin/oidc/clients");
        }
        if (builder.toString().contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        try {
            builder.append("client_id=").append(URLEncoder.encode(this.clientId, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder;
    }
}

