/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.security.Principal;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.ClaimsValidatorLookupFunction;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class JWTCredentialValidator
extends AbstractCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWTCredentialValidator.class);
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> clientAuthContextLookupStrategy = new ChildContextLookup(OAuth2ClientAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = new ClaimsValidatorLookupFunction();
    private boolean saveTokenToCredentialSet;

    public void setOAuth2ClientAuthenticationLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientAuthContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OAuth2ClientAuthenticationContext lookup strategy cannot be null");
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClaimsValidator lookup strategy cannot be null");
    }

    public void setSaveTokenToCredentialSet(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.saveTokenToCredentialSet = flag;
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        OAuth2ClientAuthenticationContext clientAuthContext = this.clientAuthContextLookupStrategy.apply(profileRequestContext);
        if (clientAuthContext == null || clientAuthContext.getClientAuthentication() == null) {
            this.log.debug("{} No OAuth 2.0 client authentication information found", (Object)this.getLogPrefix());
            return null;
        }
        ClientAuthentication clientAuth = clientAuthContext.getClientAuthentication();
        if (!ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)clientAuth.getMethod()) && !ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)clientAuth.getMethod())) {
            this.log.debug("{} OAuth client authentication for '{}' of unsupported type: {}", new Object[]{this.getLogPrefix(), clientAuth.getClientID(), clientAuth.getMethod()});
            return null;
        }
        if (!(clientAuth instanceof JWTAuthentication)) {
            this.log.warn("{} OAuth client authentication object of unexpected type: {}", (Object)this.getLogPrefix(), (Object)clientAuth.getClass().getSimpleName());
            this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)clientAuth.getClientID());
            LoginException e = new LoginException("InvalidCredentials");
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
            }
            throw e;
        }
        JWTAuthentication jwtAuth = (JWTAuthentication)clientAuth;
        String errorEventId = JWTSignatureValidationUtil.validateSignature((SecurityParametersContext)this.securityParametersLookupStrategy.apply(profileRequestContext), (SignedJWT)jwtAuth.getClientAssertion(), (String)"InvalidCredentials");
        if (errorEventId != null) {
            this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)clientAuth.getClientID());
            LoginException e = new LoginException(errorEventId);
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
            }
            throw e;
        }
        try {
            this.validateJWTClaims(profileRequestContext, jwtAuth.getClientAssertion(), clientAuth.getClientID());
        }
        catch (Exception e) {
            this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)clientAuth.getClientID());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, e, "InvalidCredentials");
            }
            throw e;
        }
        this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)clientAuth.getClientID());
        return this.populateSubject(clientAuth.getClientID(), jwtAuth.getClientAssertion());
    }

    protected void validateJWTClaims(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SignedJWT jwt, @Nonnull ClientID clientId) throws ParseException, JWTValidationException {
        JWTClaimsSet claimsSet;
        ClaimsValidator validator = this.claimsValidatorLookupStrategy.apply(profileRequestContext);
        if (validator == null) {
            this.log.warn("{} JWT validation failed for client '{}': No ClaimsValidator found in configuration", (Object)this.getLogPrefix(), (Object)clientId);
            throw new JWTValidationException("No ClaimsValidator found in configuration");
        }
        try {
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.warn("{} Could not parse the JWT from client '{}' into claims set", (Object)this.getLogPrefix(), (Object)clientId);
            throw e;
        }
        try {
            validator.validate(claimsSet, profileRequestContext);
        }
        catch (JWTValidationException e) {
            this.log.warn("{} JWT validation failed for client '{}': {}", new Object[]{this.getLogPrefix(), clientId, e.getMessage()});
            throw e;
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull @NotEmpty ClientID clientId, @Nonnull SignedJWT token) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal(clientId.getValue()));
        if (this.saveTokenToCredentialSet) {
            subject.getPublicCredentials().add(token);
        }
        return super.populateSubject(subject);
    }
}

