/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.CertificateContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.profile.config.navigate.TokenEndpointAuthMethodLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractClientAuthenticationFromRequest
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractClientAuthenticationFromRequest.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> clientAuthMethodsLookupStrategy = new TokenEndpointAuthMethodLookupFunction();
    @Nullable
    private AbstractOptionallyAuthenticatedRequest request;

    public void setClientAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client authentication methods lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Object msg;
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() != null && (msg = profileRequestContext.getInboundMessageContext().getMessage()) instanceof AbstractOptionallyAuthenticatedRequest) {
            this.request = (AbstractOptionallyAuthenticatedRequest)msg;
            return true;
        }
        this.log.warn("{} Inbound message missing or of incorrect type", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        TLSClientAuthentication tls;
        ClientAuthentication clientAuthentication = this.request.getClientAuthentication();
        OAuth2ClientAuthenticationContext ctx = (OAuth2ClientAuthenticationContext)authenticationContext.getSubcontext(OAuth2ClientAuthenticationContext.class, true);
        ctx.setClientAuthentication(clientAuthentication);
        if (clientAuthentication == null) {
            this.log.debug("{} No OAuth client credentials in request", (Object)this.getLogPrefix());
            Set<ClientAuthenticationMethod> methods = this.clientAuthMethodsLookupStrategy.apply(profileRequestContext);
            if (methods == null || !methods.contains(ClientAuthenticationMethod.NONE)) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            }
            return;
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientAuthentication.getMethod())) {
            ClientSecretBasic basic = (ClientSecretBasic)clientAuthentication;
            if (basic.getClientID() != null && basic.getClientSecret() != null) {
                UsernamePasswordContext upContext = new UsernamePasswordContext();
                upContext.setUsername(this.applyTransforms(basic.getClientID().getValue())).setPassword(basic.getClientSecret().getValue());
                authenticationContext.addSubcontext((BaseContext)upContext, true);
            } else {
                this.log.warn("{} No OAuth client credentials in basic-auth request?", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            }
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientAuthentication.getMethod())) {
            ClientSecretPost post = (ClientSecretPost)clientAuthentication;
            if (post.getClientID() != null && post.getClientSecret() != null) {
                UsernamePasswordContext upContext = new UsernamePasswordContext();
                upContext.setUsername(this.applyTransforms(post.getClientID().getValue())).setPassword(post.getClientSecret().getValue());
                authenticationContext.addSubcontext((BaseContext)upContext, true);
            } else {
                this.log.warn("{} No OAuth client credentials in POST request?", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            }
        } else if ((ClientAuthenticationMethod.TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getMethod()) || ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getMethod())) && (tls = (TLSClientAuthentication)clientAuthentication).getClientX509Certificate() != null) {
            CertificateContext certContext = new CertificateContext();
            certContext.setCertificate((Certificate)tls.getClientX509Certificate());
            authenticationContext.addSubcontext((BaseContext)certContext, true);
        }
    }
}

