/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.UserInfoResponseClaimsSetLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ClaimsAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, ClaimsSet> idTokenClaimsLookupStrategy;
    @Nonnull
    private final Function<ProfileRequestContext, ClaimsSet> userInfoClaimsLookupStrategy;

    public ClaimsAuditExtractor() {
        this.idTokenClaimsLookupStrategy = new DefaultResponseClaimsSetLookupFunction();
        this.userInfoClaimsLookupStrategy = new UserInfoResponseClaimsSetLookupFunction();
    }

    public ClaimsAuditExtractor(@Nonnull Function<ProfileRequestContext, ClaimsSet> idTokenClaimsStrategy, @Nonnull Function<ProfileRequestContext, ClaimsSet> userInfoClaimsStrategy) {
        this.idTokenClaimsLookupStrategy = (Function)Constraint.isNotNull(idTokenClaimsStrategy, (String)"IdTokenClaimsStrategy lookup strategy cannot be null");
        this.userInfoClaimsLookupStrategy = (Function)Constraint.isNotNull(userInfoClaimsStrategy, (String)"userInfoClaimsStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        ClaimsSet claims = this.idTokenClaimsLookupStrategy.apply(input);
        if (claims != null) {
            return claims.toJSONObject().keySet();
        }
        claims = this.userInfoClaimsLookupStrategy.apply(input);
        if (claims != null) {
            return claims.toJSONObject().keySet();
        }
        return Collections.emptyList();
    }
}

