/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.net.URISyntaxException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.SignUserInfoResponse;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignUserInfoResponseTest
extends BaseOIDCResponseActionTest {
    private SignUserInfoResponse action = new SignUserInfoResponse();
    SecurityParametersContext spCtx;

    private void init(String algo, Credential credential) throws ComponentInitializationException, URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setUserInfoJWSAlg(JWSAlgorithm.parse((String)algo));
        this.action.initialize();
        this.spCtx = new SecurityParametersContext();
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.spCtx.setSignatureSigningParameters(params);
        params.setSigningCredential(credential);
        params.setSignatureAlgorithm(algo);
        this.profileRequestCtx.addSubcontext((BaseContext)this.spCtx);
        this.respCtx.setUserInfo(new UserInfo(new Subject("sub")));
    }

    @Test
    public void testNoCredential() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.spCtx.getSignatureSigningParameters().setSigningCredential(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNoParameters() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.spCtx.setSignatureSigningParameters(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNoCtxt() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.profileRequestCtx.removeSubcontext(SecurityParametersContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNotInstructed() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.metadataCtx.getClientInformation().getOIDCMetadata().setUserInfoJWSAlg(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getProcessedToken());
    }

    @Test
    public void testNoUserInfo() throws ComponentInitializationException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.respCtx.setUserInfo(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    private void testSuccessMessage(JWSVerifier verifier) throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getProcessedToken());
        Assert.assertTrue((boolean)((SignedJWT)this.respCtx.getProcessedToken()).verify(verifier));
    }

    @Test
    public void testSuccessMessageRS256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS256", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageRS384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS384", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageRS512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("RS512", this.credentialRSA);
        this.testSuccessMessage((JWSVerifier)new RSASSAVerifier((RSAPublicKey)this.credentialRSA.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES256", this.credentialEC256);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC256.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES384", this.credentialEC384);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC384.getPublicKey()));
    }

    @Test
    public void testSuccessMessageES512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("ES512", this.credentialEC521);
        this.testSuccessMessage((JWSVerifier)new ECDSAVerifier((ECPublicKey)this.credentialEC521.getPublicKey()));
    }

    @Test
    public void testSuccessMessageHS256() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS256", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }

    @Test
    public void testSuccessMessageHS384() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS384", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }

    @Test
    public void testSuccessMessageHS512() throws ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.init("HS512", this.credentialHMAC);
        this.testSuccessMessage((JWSVerifier)new MACVerifier(this.credentialHMAC.getSecretKey()));
    }
}

