/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.criterion.ClientInformationCriterion;
import net.shibboleth.idp.plugin.oidc.op.security.impl.OIDCClientInformationSignatureValidationParametersResolver;
import net.shibboleth.oidc.jwk.RemoteJwkSetCache;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.impl.OIDCSignatureValidationParameters;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.mockito.Mockito;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCClientInformationSignatureValidationParametersResolverTest
extends OpenSAMLInitBaseTestCase {
    private OIDCClientInformationSignatureValidationParametersResolver resolver;
    private CriteriaSet criteria;
    private OIDCClientMetadata metaData;
    private JWKSet jwkSet;

    @BeforeMethod
    protected void setUp() throws ParseException {
        this.jwkSet = JWKSet.parse((String)"{\n   \"keys\":[\n      {\n         \"kty\":\"RSA\",\n         \"e\":\"AQAB\",\n         \"use\":\"enc\",\n         \"kid\":\"testkeyRSAEncryption\",\n         \"n\":\"47mkdLGrenv7QFkAWv1JryydVjq8HsEVCKz-qRttVe2II1-lQc-4sObf-9X0LtAwdtK0g1_EpRzZNuGaK2nFISr9uZQQ5evNHETgUKE2oKJs3r0wnfgvEZVHV6wXg4B7NRmDBgphExIYndBt__L-tC9_S_isaJOXQ_PAx17621pmxdyg8WEnJx9Azc23vH-Cii0ttMxDLNqUTu-tdgtZ8eo0IX7VPBWAnXVi0bRKHJuuvzJ4B8QqwsZsj8hGrwqNkRMoJVEiz-5M6ACLo-rgGNjtCBJRaezolrHSCc-r-hZbAaBKq0dOPRNPcMtRm8TUdmuRKBY7rXaFi7zGV7XDdw\"\n      },\n      {\n         \"kty\":\"RSA\",\n         \"e\":\"AQAB\",\n         \"use\":\"sig\",\n         \"kid\":\"testkeyRS\",\n         \"n\":\"pNf03ghVzMAw5sWrwDAMAZdSYNY2q7OVlxMInljMgz8XB5mf8XKH3EtP7AKrb8IAf7rGhfuH3T1N1C7F-jwIeYjXxMm2nIAZ0hXApgbccvBpf4n2H7IZflMjt4A3tt587QQSxQ069drCP4sYevxhTcLplJy6RWA0cLj-5CHyWy94zPeeA4GRd6xgHFLz0RNiSF0pF0kE4rmRgQVZ-b4_BmD9SsWnIpwhms5Ihciw36WyAGQUeZqULGsfwAMwlNLIaTCBLAoRgv370p-XsLrgz86pTkNBJqXP5GwI-ZfgiLmJuHjQ9l85KqHM87f-QdsqiV8KoRcslgXPqb6VOTJBVw\"\n      },\n      {\n         \"kty\":\"EC\",\n         \"use\":\"sig\",\n         \"crv\":\"P-256\",\n         \"kid\":\"testkeyES256\",\n         \"x\":\"2uzfE1oK0cf1_c11SFc9vFdGLnJoH3e0AKTrGPAmUis\",\n         \"y\":\"14410NGKqwLM58b26ZcvGOruFixpHt_SJTw8I5wwgLQ\"\n      },\n      {\n         \"kty\":\"EC\",\n         \"use\":\"sig\",\n         \"crv\":\"P-384\",\n         \"kid\":\"testkeyES384\",\n         \"x\":\"-loVdvssxvUq_jCPULEk0cMkF4uvEGfHfbh8az8T9J_er6frv0jhosDLCxoLE7E6\",\n         \"y\":\"Er9Blt5x5ADxQXmezf3OEmQbLjjblgB9XwbXXcQyEOQ2qXNv659AgdZiq4UJBnPH\"\n      },\n      {\n         \"kty\":\"EC\",\n         \"use\":\"sig\",\n         \"crv\":\"P-521\",\n         \"kid\":\"testkeyES512\",\n         \"x\":\"AVjIdU6xZBwRdC9yZYyqT583EM3GbxdVyGwinPqeba0EildGZWM1L7HfJXV_r_cOBcuCsEZcuSqFO3v5KRLY5Wj-\",\n         \"y\":\"ATeLywfo7kLDEwUCm8ZQFynqH36WXSdQClAz2cZ63tHfjSumm_SfMOfdWEDmdtgkbVDrBXWYqWoYaofigmDZkxok\"\n      },\n      {\n         \"kty\":\"EC\",\n         \"crv\":\"P-521\",\n         \"kid\":\"testkeyES512-2\",\n         \"x\":\"AQL7ZCkzcAyuUdaqYiCSAf2u2MR_l4rqSppQ8lvEEjmjy7ETiPB77BqeH7glJ6xtkK1YhmHxKDKz0E0zdmqWWVYp\",\n         \"y\":\"AXI7UFlH-Zy2jEf1XoY3NHblkJDsOK4kiv82fRrKtHAoKM_ud25XNzT3lrfbJ--zZlmWUB7fV2jHR0pbmjOOrEF_\"\n      }\n   ]\n}");
    }

    protected void initTest(RemoteJwkSetCache remoteJwkSetCache) throws Exception {
        this.resolver = new OIDCClientInformationSignatureValidationParametersResolver();
        ArrayList<SignatureSigningConfiguration> configs = new ArrayList<SignatureSigningConfiguration>();
        SignatureSigningConfiguration signConfig = (SignatureSigningConfiguration)Mockito.mock(SignatureSigningConfiguration.class);
        Mockito.when((Object)signConfig.getSignatureAlgorithms()).thenReturn(Arrays.asList("RS256", "HS256", "HS384", "HS512", "ES256", "ES384", "ES512"));
        configs.add(signConfig);
        this.criteria = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
        this.metaData = new OIDCClientMetadata();
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.ES256);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.ES256);
        if (remoteJwkSetCache != null) {
            this.resolver.setRemoteJwkSetCache(remoteJwkSetCache);
            this.metaData.setJWKSetURI(new URI("https://rp.example.org/jwks"));
        } else {
            this.metaData.setJWKSet(this.jwkSet);
        }
        OIDCClientInformation clientInformation = new OIDCClientInformation(new ClientID(), new Date(), this.metaData, new Secret("abcdefgh"));
        this.criteria.add((Object)new ClientInformationCriterion(clientInformation));
    }

    @Test
    public void testRequestObjectParameters() throws Exception {
        this.initTest(null);
        this.testSigningValidationES256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersRemoteKeys() throws Exception {
        RemoteJwkSetCache remoteJwkSetCache = (RemoteJwkSetCache)Mockito.mock(RemoteJwkSetCache.class);
        Mockito.when((Object)remoteJwkSetCache.fetch((URI)Mockito.any(), (Instant)Mockito.any())).thenReturn((Object)this.jwkSet);
        this.initTest(remoteJwkSetCache);
        this.testSigningValidationES256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersNoKeys() throws Exception {
        RemoteJwkSetCache remoteJwkSetCache = (RemoteJwkSetCache)Mockito.mock(RemoteJwkSetCache.class);
        Mockito.when((Object)remoteJwkSetCache.fetch((URI)Mockito.any(), (Instant)Mockito.any())).thenReturn(null);
        this.initTest(remoteJwkSetCache);
        this.resolver.setParameterType(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
        Assert.assertNull((Object)this.resolver.resolveSingle(this.criteria));
    }

    @Test
    public void testRequestObjectParametersES384() throws Exception {
        this.initTest(null);
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.ES384);
        this.testSigningValidationES384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersES512() throws Exception {
        this.initTest(null);
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.ES512);
        this.testSigningValidationES512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersHS256() throws Exception {
        this.initTest(null);
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.HS256);
        this.testSigningValidationHS256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersHS384() throws Exception {
        this.initTest(null);
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.HS384);
        this.testSigningValidationHS384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testRequestObjectParametersHS512() throws Exception {
        this.initTest(null);
        this.metaData.setRequestObjectJWSAlg(JWSAlgorithm.HS512);
        this.testSigningValidationHS512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.REQUEST_OBJECT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParameters() throws Exception {
        this.initTest(null);
        this.testSigningValidationES256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParametersES384() throws Exception {
        this.initTest(null);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.ES384);
        this.testSigningValidationES384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParametersES512() throws Exception {
        this.initTest(null);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.ES512);
        this.testSigningValidationES512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParametersHS256() throws Exception {
        this.initTest(null);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.HS256);
        this.testSigningValidationHS256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParametersHS384() throws Exception {
        this.initTest(null);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.HS384);
        this.testSigningValidationHS384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    @Test
    public void testTokenEndpointJwtParametersHS512() throws Exception {
        this.initTest(null);
        this.metaData.setTokenEndpointAuthJWSAlg(JWSAlgorithm.HS512);
        this.testSigningValidationHS512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType.TOKEN_ENDPOINT_JWT_VALIDATION);
    }

    protected void testSigningValidationHS256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS256");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationHS384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS384");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationHS512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"HS512");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((JWKCredential)params.getValidationCredentials().get(0)).getSecretKey());
    }

    protected void testSigningValidationES256(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES256");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_256);
    }

    protected void testSigningValidationES384(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES384");
        Assert.assertTrue((params.getValidationCredentials().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_384);
    }

    protected void testSigningValidationES512(OIDCClientInformationSignatureValidationParametersResolver.ParameterType parameterType) throws ResolverException {
        this.resolver.setParameterType(parameterType);
        OIDCSignatureValidationParameters params = (OIDCSignatureValidationParameters)this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"ES512");
        Assert.assertTrue((params.getValidationCredentials().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(0)).getPublicKey())).getParams()), (Object)Curve.P_521);
        Assert.assertEquals((Object)Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)((JWKCredential)params.getValidationCredentials().get(1)).getPublicKey())).getParams()), (Object)Curve.P_521);
    }
}

