/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URISyntaxException;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateCodeChallenge;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateCodeChallengeTest
extends BaseOIDCResponseActionTest {
    private ValidateCodeChallenge action;
    private boolean forcePkce;
    private boolean allowPlain;

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException, ParseException {
        this.action = new ValidateCodeChallenge();
        this.action.setForcePKCECondition(prc -> this.forcePkce);
        this.action.setAllowPKCEPlainCondition(prc -> this.allowPlain);
        this.action.initialize();
    }

    @Test
    public void testUnforcedAllowMissingChallenge() throws ComponentInitializationException {
        this.forcePkce = false;
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForcedFailsWhenMissingChallenge() throws ComponentInitializationException {
        this.forcePkce = true;
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCECodeChallengeRequired");
    }

    @Test
    public void testForcedFailsWhenEmptyChallenge() throws ComponentInitializationException, ParseException {
        this.forcePkce = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("", null));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCECodeChallengeRequired");
    }

    @Test
    public void testUnforcedPNolainAllowedFailsWithUnknownMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "unsupported"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testUnforcedNoPlainAllowedFailsWithDefaultMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", null));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testUnforcedNoPlainAllowedFailsWithEmptyMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", ""));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testUnforcedNoPlainAllowedFailsWithPlainMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "plain"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testUnforcedNoPlainAllowedSuccessWithS256Method() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "S256"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForcedNoPlainAllowedFailsWithUnknownMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "unsupported"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testForcedNoPlainAllowedFailsWithDefaultMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", null));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testForcedNoPlainAllowedFailsWithEmptyMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", ""));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testForcedNoPlainAllowedFailsWithPlainMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "plain"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testForcedNoPlainAllowedSuccessWithS256Method() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = false;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "S256"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testUnforcedPlainAllowedFailsWithUnknownMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "unsupported"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testUnforcedPlainAllowedSuccessWithDefaultMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", null));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testUnforcedPlainAllowedSuccessWithEmptyMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", ""));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testUnforcedPlainAllowedSuccesssWithPlainMethod() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "plain"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testUnforcedPlainAllowedSuccessWithS256Method() throws ParseException {
        this.forcePkce = false;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "S256"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForcedPlainAllowedFailsWithUnknownMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "unsupported"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"PKCEVerifierTransformAlgorithmNotSupported");
    }

    @Test
    public void testForcedPlainAllowedSuccessWithDefaultMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", null));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForcedPlainAllowedSuccessWithEmptyMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", ""));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForcedPlainAllowedSuccessWithPlainMethod() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "plain"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testForceoPlainAllowedSuccessWithS256Method() throws ParseException {
        this.forcePkce = true;
        this.allowPlain = true;
        this.setAuthenticationRequest(this.populateCodeChallenge("asdsadasddsa", "S256"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    protected AuthenticationRequest populateCodeChallenge(String challenge, String challengeMethod) throws ParseException {
        String authnRequest = this.request.toQueryString() + "&code_challenge=" + challenge;
        return AuthenticationRequest.parse((String)(challengeMethod == null ? authnRequest : authnRequest + "&code_challenge_method=" + challengeMethod));
    }
}

