/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.net.URI;
import java.time.Duration;
import java.util.function.Predicate;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeAuthenticationContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeAuthenticationContextTest {
    private InitializeAuthenticationContext action;
    private RequestContext requestCtx;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void init() throws ComponentInitializationException, ParseException {
        this.action = new InitializeAuthenticationContext();
        this.action.initialize();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).prompt(new Prompt(new Prompt.Type[]{Prompt.Type.LOGIN})).loginHint("foo").build();
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)req).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        AuthenticationContext existingContext = new AuthenticationContext();
        existingContext.setAuthenticationResult(new AuthenticationResult("flowId", new Subject()));
        this.prc.addSubcontext((BaseContext)existingContext);
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)new OIDCAuthenticationResponseContext());
    }

    @Test
    public void testOIDCAuthnRequestForcedWithHintedName() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertTrue((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertNull((Object)authnCtx.getMaxAge());
        Assert.assertEquals((String)authnCtx.getHintedName(), (String)"foo");
    }

    @Test
    public void testOIDCAuthnRequestPassive() {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).prompt(new Prompt(new Prompt.Type[]{Prompt.Type.NONE})).maxAge(5).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, false);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertFalse((boolean)authnCtx.isForceAuthn());
        Assert.assertTrue((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getMaxAge(), (Object)Duration.ofSeconds(5L));
    }

    @Test
    public void testOIDCAuthnRequestWithoutPrompt() {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, false);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertFalse((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertNull((Object)authnCtx.getMaxAge());
    }

    @Test
    public void testOIDCAuthnRequestWithoutPromptForceAuthnViaPredicate() throws ComponentInitializationException {
        this.action = new InitializeAuthenticationContext();
        this.action.setForceAuthnPredicate((Predicate)Predicates.alwaysTrue());
        this.action.initialize();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, false);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertTrue((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertNull((Object)authnCtx.getMaxAge());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testSetNullLoginHintLookupStrategy() throws Exception {
        this.action = new InitializeAuthenticationContext();
        this.action.setLoginHintLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testSetNullPromptLookupStrategy() throws Exception {
        this.action = new InitializeAuthenticationContext();
        this.action.setPromptLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testSetNullMaxAgeLookupStrategy() throws Exception {
        this.action = new InitializeAuthenticationContext();
        this.action.setMaxAgeLookupStrategy(null);
    }
}

