/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.ParseException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.FormOutboundKeySetResponseMessage;
import net.shibboleth.idp.plugin.oidc.op.profile.spring.factory.BasicJWKCredentialFactoryBean;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.profile.config.OIDCPublishKeySetConfiguration;
import net.shibboleth.oidc.profile.config.OIDCSecurityConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormOutboundKeySetResponseMessageTest {
    private ProfileRequestContext profileRequestCtx;
    private FormOutboundKeySetResponseMessage action;
    private RequestContext requestCtx;
    private OIDCPublishKeySetConfiguration profileConf;
    private RelyingPartyContext rpCtx;

    @BeforeMethod
    public void init() throws Exception {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        MessageContext msgCtx = new MessageContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.profileRequestCtx.setOutboundMessageContext(msgCtx);
        this.rpCtx = (RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class, true);
        ArrayList<Credential> signCreds = new ArrayList<Credential>();
        BasicJWKCredentialFactoryBean factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-rs.jwk"));
        factory.afterPropertiesSet();
        signCreds.add((Credential)factory.getObject());
        factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-encryption-rsa.jwk"));
        factory.afterPropertiesSet();
        ArrayList<Credential> encCreds = new ArrayList<Credential>();
        encCreds.add((Credential)factory.getObject());
        SignatureSigningConfiguration signConfig = (SignatureSigningConfiguration)Mockito.mock(SignatureSigningConfiguration.class);
        Mockito.when((Object)signConfig.getSigningCredentials()).thenReturn(signCreds);
        EncryptionConfiguration decConfig = (EncryptionConfiguration)Mockito.mock(EncryptionConfiguration.class);
        Mockito.when((Object)decConfig.getKeyTransportEncryptionCredentials()).thenReturn(encCreds);
        OIDCSecurityConfiguration secConf = new OIDCSecurityConfiguration();
        secConf.setSignatureSigningConfiguration(signConfig);
        secConf.setRequestObjectDecryptionConfiguration(decConfig);
        this.profileConf = new OIDCPublishKeySetConfiguration();
        this.profileConf.setSecurityConfiguration((SecurityConfiguration)secConf);
        this.rpCtx.setProfileConfig((ProfileConfiguration)this.profileConf);
        this.action = new FormOutboundKeySetResponseMessage();
        this.action.initialize();
    }

    @Test
    public void testSuccessMessage() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException, java.text.ParseException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(this.profileRequestCtx.getOutboundMessageContext().getMessage() instanceof JSONSuccessResponse));
        JSONSuccessResponse resp = (JSONSuccessResponse)this.profileRequestCtx.getOutboundMessageContext().getMessage();
        Assert.assertTrue((boolean)resp.indicatesSuccess());
        JSONObject keyset = resp.toHTTPResponse().getContentAsJSONObject();
        JSONArray keys = (JSONArray)keyset.get((Object)"keys");
        Assert.assertEquals((int)keys.size(), (int)3);
    }

    @Test
    public void testFailNoSecConf() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.profileConf.setSecurityConfiguration(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testFailNoProfileConf() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.rpCtx.setProfileConfig(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test
    public void testFailNoRPCtx() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.profileRequestCtx.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }
}

