/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.DecryptRequestObject;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.impl.OIDCDecryptionParameters;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionParameters;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DecryptRequestObjectTest {
    private ProfileRequestContext prc;
    private DecryptRequestObject action;
    private RequestContext requestCtx;
    private OIDCMetadataContext oidcCtx;
    private OIDCAuthenticationResponseContext oidcRespCtx;
    private KeyPair kp;

    @BeforeMethod
    public void setup() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.oidcCtx = (OIDCMetadataContext)this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.oidcRespCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcRespCtx);
        OIDCClientMetadata metaData = new OIDCClientMetadata();
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, metaData, new Secret("ultimatetopsecretultimatetopsecret"), null, null);
        this.oidcCtx.setClientInformation(information);
        BaseContext ctx = this.prc.getSubcontext(RelyingPartyContext.class, true);
        EncryptionContext encCtx = (EncryptionContext)ctx.getSubcontext(EncryptionContext.class, true);
        OIDCDecryptionParameters params = new OIDCDecryptionParameters();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialRSA = new BasicJWKCredential();
        credentialRSA.setPrivateKey(this.kp.getPrivate());
        params.getKeyTransportDecryptionCredentials().add(credentialRSA);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialRSA2 = new BasicJWKCredential();
        credentialRSA2.setPrivateKey(this.kp.getPrivate());
        params.getKeyTransportDecryptionCredentials().add(credentialRSA2);
        params.setKeyTransportEncryptionAlgorithm("RSA-OAEP-256");
        params.setDataEncryptionAlgorithm("A128CBC-HS256");
        encCtx.setAttributeEncryptionParameters((EncryptionParameters)params);
        this.action = new DecryptRequestObject();
        this.action.initialize();
    }

    @Test
    public void testSuccessNoObject() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testSuccessNotJWE() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, ParseException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().subject("alice").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)"alice", (String)this.oidcRespCtx.getRequestObject().getJWTClaimsSet().getSubject());
    }

    private void setObject(JWEAlgorithm alg, EncryptionMethod enc) throws JOSEException, ParseException {
        PlainJWT plainJWT = new PlainJWT(new JWTClaimsSet.Builder().subject("alice").build());
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(alg, enc).contentType("JWT").build(), new Payload(plainJWT.serialize()));
        jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)this.kp.getPublic()));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).requestObject((JWT)EncryptedJWT.parse((String)jweObject.serialize())).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcRespCtx.setRequestObject(req.getRequestObject());
    }

    @Test
    public void testRequestObjectDecryptSuccess() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.setObject(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128CBC_HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)"alice", (String)this.oidcRespCtx.getRequestObject().getJWTClaimsSet().getSubject());
    }

    @Test
    public void testRequestObjectDecryptFailureNoMatchingKey() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        this.setObject(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128CBC_HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectDecryptFailureNoMatchingAlg() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.setObject(JWEAlgorithm.RSA_OAEP, EncryptionMethod.A128CBC_HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectDecryptFailureNoMatchingEnc() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        this.setObject(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128GCM);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestObject");
    }

    @Test
    public void testRequestObjectFailureNoParameters() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        ((EncryptionContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, false)).getSubcontext(EncryptionContext.class, false)).setAttributeEncryptionParameters(null);
        this.setObject(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128CBC_HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testRequestObjectFailureNoEncCtx() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, JOSEException, ParseException {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, false)).removeSubcontext(EncryptionContext.class);
        this.setObject(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128CBC_HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }
}

