/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.spring.factory.BasicJWKCredentialFactoryBean;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.storage.RevocationCache;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;

public abstract class BaseOIDCResponseActionTest
extends OpenSAMLInitBaseTestCase {
    protected RequestContext requestCtx;
    protected OIDCAuthenticationResponseContext respCtx;
    protected OIDCMetadataContext metadataCtx;
    protected AuthenticationRequest request;
    protected RelyingPartyContext rpCtx;
    protected final String subject;
    protected final String clientId;
    private DataSealer dataSealer;
    protected final IdentifierGenerationStrategy idGenerator = new SecureRandomIdentifierGenerationStrategy();
    protected ProfileRequestContext profileRequestCtx;
    protected Credential credentialRSA;
    protected Credential credentialEC256;
    protected Credential credentialEC384;
    protected Credential credentialEC521;
    protected Credential credentialHMAC;

    public BaseOIDCResponseActionTest() {
        this.subject = "generatedSubject";
        this.clientId = "s6BhdRkqt3";
        try {
            BasicJWKCredentialFactoryBean factory = new BasicJWKCredentialFactoryBean();
            factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es.jwk"));
            factory.afterPropertiesSet();
            this.credentialEC256 = (Credential)factory.getObject();
            factory = new BasicJWKCredentialFactoryBean();
            factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es384.jwk"));
            factory.afterPropertiesSet();
            this.credentialEC384 = (Credential)factory.getObject();
            factory = new BasicJWKCredentialFactoryBean();
            factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-es521.jwk"));
            factory.afterPropertiesSet();
            this.credentialEC521 = (Credential)factory.getObject();
            factory = new BasicJWKCredentialFactoryBean();
            factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-rs.jwk"));
            factory.afterPropertiesSet();
            this.credentialRSA = (Credential)factory.getObject();
            factory = new BasicJWKCredentialFactoryBean();
            factory.setResource((Resource)new ClassPathResource("credentials/idp-signing-dir.jwk"));
            factory.afterPropertiesSet();
            this.credentialHMAC = (Credential)factory.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.request = AuthenticationRequest.parse((String)"response_type=id_token+token&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20email%20profile%20offline_access&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)this.request).buildRequestContext();
        MessageContext msgCtx = new MessageContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.profileRequestCtx.setOutboundMessageContext(msgCtx);
        this.respCtx = new OIDCAuthenticationResponseContext();
        this.profileRequestCtx.getOutboundMessageContext().addSubcontext((BaseContext)this.respCtx);
        this.metadataCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().addSubcontext((BaseContext)new OIDCMetadataContext());
        OIDCClientInformation information = new OIDCClientInformation(new ClientID(this.clientId), new Date(), new OIDCClientMetadata(), new Secret());
        this.metadataCtx.setClientInformation(information);
        this.rpCtx = (RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class, true);
        this.rpCtx.setRelyingPartyId(this.clientId);
        this.respCtx.setSubject(this.subject);
        this.rpCtx.setProfileConfig((ProfileConfiguration)new OIDCAuthorizationConfiguration());
    }

    protected void setAuthenticationRequest(AuthenticationRequest req) {
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
    }

    protected void setTokenRequest(TokenRequest req) {
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
    }

    protected void setUserInfoRequest(UserInfoRequest req) {
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
    }

    protected void setIdTokenToResponseContext(String iss, String sub, String aud, Instant exp, Instant iat) {
        ArrayList<Audience> audience = new ArrayList<Audience>();
        audience.add(new Audience(aud));
        IDTokenClaimsSet idToken = new IDTokenClaimsSet(new Issuer(iss), new Subject(sub), audience, Date.from(exp), Date.from(iat));
        this.respCtx.setIDToken(idToken);
    }

    protected void signIdTokenInResponseContext() throws ParseException, JOSEException {
        SignedJWT jwt = null;
        jwt = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID("id").build(), this.respCtx.getIDToken().toJWTClaimsSet());
        jwt.sign((JWSSigner)new RSASSASigner(this.credentialRSA.getPrivateKey()));
        this.respCtx.setProcessedToken((JWT)jwt);
    }

    protected void setUserInfoResponseToResponseContext(String sub) {
        UserInfo info = new UserInfo(new Subject(sub));
        this.respCtx.setUserInfo(info);
    }

    protected void signUserInfoResponseInResponseContext() throws ParseException, JOSEException {
        SignedJWT jwt = null;
        jwt = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID("id").build(), this.respCtx.getUserInfo().toJWTClaimsSet());
        jwt.sign((JWSSigner)new RSASSASigner(this.credentialRSA.getPrivateKey()));
        this.respCtx.setProcessedToken((JWT)jwt);
    }

    public DataSealer getDataSealer() throws ComponentInitializationException, NoSuchAlgorithmException {
        if (this.dataSealer == null) {
            this.dataSealer = BaseOIDCResponseActionTest.initializeDataSealer();
        }
        return this.dataSealer;
    }

    public static DataSealer initializeDataSealer() throws ComponentInitializationException, NoSuchAlgorithmException {
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeystoreResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.jks")));
        strategy.setKeyVersionResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.kver")));
        strategy.setKeystorePassword("password");
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("password");
        strategy.initialize();
        DataSealer dataSealer = new DataSealer();
        dataSealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        dataSealer.setRandom(SecureRandom.getInstance("SHA1PRNG"));
        dataSealer.initialize();
        return dataSealer;
    }

    protected static <K, V> Map<K, V> addEntryToMap(Map<K, V> map, K key, V value) {
        return Stream.of(map, Map.of(key, value)).flatMap(newMap -> newMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public class MockRevocationCache
    extends RevocationCache {
        boolean revoke;
        boolean isRevoked;

        public MockRevocationCache(boolean revocationQueryOutcome, boolean revokeActionStatus) {
            this.revoke = revokeActionStatus;
            this.isRevoked = revocationQueryOutcome;
        }

        public void doInitialize() throws ComponentInitializationException {
        }

        public synchronized boolean revoke(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
            return this.revoke;
        }

        public synchronized boolean isRevoked(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
            return this.isRevoked;
        }
    }
}

