/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddSecurityConfigurationToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddSecurityConfigurationToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddSecurityConfigurationToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddSecurityConfigurationToClientMetadata();
        this.action.initialize();
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddSecurityConfigurationToClientMetadata();
    }

    protected static void initializeRpCtx(ProfileRequestContext profileRequestCtx, List<String> signingAlgs, List<String> encyrptionAlgs, List<String> encryptionEncs) {
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestCtx.getSubcontext(RelyingPartyContext.class);
        ProfileConfiguration profileConfig = (ProfileConfiguration)Mockito.mock(ProfileConfiguration.class);
        SecurityConfiguration secConfig = (SecurityConfiguration)Mockito.mock(SecurityConfiguration.class);
        SignatureSigningConfiguration signingConfig = (SignatureSigningConfiguration)Mockito.mock(SignatureSigningConfiguration.class);
        Mockito.when((Object)signingConfig.getSignatureAlgorithms()).thenReturn(signingAlgs);
        Mockito.when((Object)secConfig.getSignatureSigningConfiguration()).thenReturn((Object)signingConfig);
        EncryptionConfiguration encryptionConfig = (EncryptionConfiguration)Mockito.mock(EncryptionConfiguration.class);
        Mockito.when((Object)encryptionConfig.getDataEncryptionAlgorithms()).thenReturn(encryptionEncs);
        Mockito.when((Object)encryptionConfig.getKeyTransportEncryptionAlgorithms()).thenReturn(encyrptionAlgs);
        Mockito.when((Object)secConfig.getEncryptionConfiguration()).thenReturn((Object)encryptionConfig);
        Mockito.when((Object)profileConfig.getSecurityConfiguration(profileRequestCtx)).thenReturn((Object)secConfig);
        rpCtx.setProfileConfig(profileConfig);
    }

    protected void setUpContext(OIDCClientMetadata input, OIDCClientMetadata output, List<String> signingAlgs, List<String> encryptionAlgs, List<String> encryptionEncs) throws ComponentInitializationException {
        super.setUpContext(input, output);
        AddSecurityConfigurationToClientMetadataTest.initializeRpCtx(this.profileRequestCtx, signingAlgs, encryptionAlgs, encryptionEncs);
    }

    @Test
    public void testEmptySignatureAlgorithmsListWithoutRequest() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testSignatureAlgorithmsListWithEmptyRequest() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getIDTokenJWSAlg(), (Object)JWSAlgorithm.RS256);
        Assert.assertNull((Object)output.getIDTokenJWEEnc());
        Assert.assertNull((Object)output.getIDTokenJWEAlg());
    }

    @Test
    public void testIDTokenSignatureAlgorithmsListWithRS256Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWSAlg(JWSAlgorithm.RS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getIDTokenJWSAlg(), (Object)JWSAlgorithm.RS256);
        Assert.assertNull((Object)output.getIDTokenJWEEnc());
        Assert.assertNull((Object)output.getIDTokenJWEAlg());
    }

    @Test
    public void testIDTokenSignatureAlgorithmsListWithES512Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWSAlg(JWSAlgorithm.ES512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, List.of("RS256", "ES512"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getIDTokenJWSAlg(), (Object)JWSAlgorithm.ES512);
        Assert.assertNull((Object)output.getIDTokenJWEEnc());
        Assert.assertNull((Object)output.getIDTokenJWEAlg());
    }

    @Test
    public void testIDTokenInvalidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWEAlg(null);
        input.setIDTokenJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), null, null);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testIDTokenUnsupportedKeyTransportEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setIDTokenJWEEnc(EncryptionMethod.A256CBC_HS512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testIDTokenUnsupportedEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWEAlg(new JWEAlgorithm("A128GCMKW"));
        input.setIDTokenJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testIDTokenValidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setIDTokenJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setIDTokenJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getIDTokenJWSAlg(), (Object)JWSAlgorithm.RS256);
        Assert.assertEquals((Object)output.getIDTokenJWEAlg(), (Object)new JWEAlgorithm("RSA1_5"));
        Assert.assertEquals((Object)output.getIDTokenJWEEnc(), (Object)EncryptionMethod.A128CBC_HS256);
    }

    @Test
    public void testUserInfoSignatureAlgorithmsListWithRS256Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWSAlg(JWSAlgorithm.RS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getUserInfoJWSAlg(), (Object)JWSAlgorithm.RS256);
        Assert.assertNull((Object)output.getUserInfoJWEEnc());
        Assert.assertNull((Object)output.getUserInfoJWEAlg());
    }

    @Test
    public void testUserInfoSignatureAlgorithmsListWithES512Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWSAlg(JWSAlgorithm.ES512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, List.of("RS256", "ES512"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getUserInfoJWSAlg(), (Object)JWSAlgorithm.ES512);
        Assert.assertNull((Object)output.getUserInfoJWEEnc());
        Assert.assertNull((Object)output.getUserInfoJWEAlg());
    }

    @Test
    public void testUserInfoInvalidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWEAlg(null);
        input.setUserInfoJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), null, null);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testUserInfoUnsupportedKeyTransportEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setUserInfoJWEEnc(EncryptionMethod.A256CBC_HS512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testUserInfoUnsupportedEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWEAlg(new JWEAlgorithm("A128GCMKW"));
        input.setUserInfoJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testUserInfoValidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setUserInfoJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setUserInfoJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Collections.singletonList("RS256"), Collections.singletonList("RSA1_5"), Collections.singletonList("A128CBC-HS256"));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getUserInfoJWEAlg(), (Object)new JWEAlgorithm("RSA1_5"));
        Assert.assertEquals((Object)output.getUserInfoJWEEnc(), (Object)EncryptionMethod.A128CBC_HS256);
    }
}

