/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddResponseTypesToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddResponseTypesToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        AddResponseTypesToClientMetadata newAction = new AddResponseTypesToClientMetadata();
        com.google.common.base.Predicate predicate = Predicates.alwaysTrue();
        newAction.setAuthorizationCodeFlowEnabled((Predicate)predicate);
        newAction.setImplicitFlowEnabled((Predicate)predicate);
        HashMap<ResponseType, com.google.common.base.Predicate> supportedResponseTypes = new HashMap<ResponseType, com.google.common.base.Predicate>();
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), predicate);
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}), predicate);
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.TOKEN, OIDCResponseTypeValue.ID_TOKEN}), predicate);
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN}), predicate);
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN}), predicate);
        supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN, OIDCResponseTypeValue.ID_TOKEN}), predicate);
        newAction.setSupportedResponseTypes(supportedResponseTypes);
        return newAction;
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = this.constructAction();
        this.action.initialize();
    }

    @Test
    public void testNoRequest() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Set resultTypes = result.getResponseTypes();
        Assert.assertNotNull((Object)resultTypes);
        Assert.assertEquals((int)resultTypes.size(), (int)1);
        Assert.assertTrue((boolean)resultTypes.contains(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE})));
    }

    @Test
    public void testNotSupported() throws ComponentInitializationException {
        this.testResponseTypes(Arrays.asList(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.NONE})), "InvalidMessage", new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.NONE}));
    }

    @Test
    public void testOneNotSupported() throws ComponentInitializationException {
        this.testResponseTypes(Arrays.asList(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.NONE})), null, new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}), new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.NONE}));
    }

    @Test
    public void testToken() throws ComponentInitializationException {
        this.testResponseTypes(new ArrayList<ResponseType>(), "InvalidMessage", new ResponseType(new ResponseType.Value[]{ResponseType.Value.TOKEN}));
    }

    @Test
    public void testIdToken() throws ComponentInitializationException {
        this.testResponseTypes(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}));
    }

    @Test
    public void testCode() throws ComponentInitializationException {
        this.testResponseTypes(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}));
    }

    @Test
    public void testTwo() throws ComponentInitializationException {
        this.testResponseTypes(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.CODE}));
    }

    @Test
    public void testAll() throws ComponentInitializationException {
        this.testResponseTypes(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.CODE, ResponseType.Value.TOKEN}));
    }

    protected void testResponseTypes(ResponseType ... responseTypes) throws ComponentInitializationException {
        this.testResponseTypes(new ArrayList<ResponseType>(), null, responseTypes);
    }

    protected void testResponseTypes(List<ResponseType> ignoredTypes, String expectedEventId, ResponseType ... responseTypes) throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setResponseTypes(new HashSet<ResponseType>(Arrays.asList(responseTypes)));
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        if (expectedEventId != null) {
            ActionTestingSupport.assertEvent((Event)event, (String)expectedEventId);
            return;
        }
        Assert.assertNull((Object)event);
        Set resultTypes = result.getResponseTypes();
        Assert.assertNotNull((Object)resultTypes);
        int length = ignoredTypes == null ? responseTypes.length : responseTypes.length - ignoredTypes.size();
        Assert.assertEquals((int)resultTypes.size(), (int)length);
        for (ResponseType responseType : responseTypes) {
            if (ignoredTypes.contains(responseType)) {
                Assert.assertFalse((boolean)resultTypes.contains(responseType));
                continue;
            }
            Assert.assertTrue((boolean)resultTypes.contains(responseType));
        }
    }
}

