/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddGrantTypeToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddGrantTypeToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        AddGrantTypeToClientMetadata newAction = new AddGrantTypeToClientMetadata();
        com.google.common.base.Predicate predicate = Predicates.alwaysTrue();
        newAction.setAuthorizationCodeFlowEnabled((Predicate)predicate);
        newAction.setImplicitFlowEnabled((Predicate)predicate);
        newAction.setRefreshTokensEnabled((Predicate)predicate);
        return newAction;
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = this.constructAction();
        this.action.initialize();
    }

    @Test
    public void testNoRequest() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Set resultTypes = result.getGrantTypes();
        Assert.assertNotNull((Object)resultTypes);
        Assert.assertEquals((int)resultTypes.size(), (int)3);
        Assert.assertTrue((boolean)resultTypes.contains(GrantType.AUTHORIZATION_CODE));
        Assert.assertTrue((boolean)resultTypes.contains(GrantType.IMPLICIT));
        Assert.assertTrue((boolean)resultTypes.contains(GrantType.REFRESH_TOKEN));
    }

    @Test
    public void testNotSupported() throws ComponentInitializationException {
        this.testGrantTypes(Arrays.asList(GrantType.CLIENT_CREDENTIALS), "InvalidMessage", GrantType.CLIENT_CREDENTIALS);
    }

    @Test
    public void testOneNotSupported() throws ComponentInitializationException {
        this.testGrantTypes(Arrays.asList(GrantType.CLIENT_CREDENTIALS), null, GrantType.AUTHORIZATION_CODE, GrantType.CLIENT_CREDENTIALS);
    }

    @Test
    public void testAuthzCode() throws ComponentInitializationException {
        this.testGrantTypes(GrantType.AUTHORIZATION_CODE);
    }

    @Test
    public void testImplicit() throws ComponentInitializationException {
        this.testGrantTypes(GrantType.IMPLICIT);
    }

    @Test
    public void testRefresh() throws ComponentInitializationException {
        this.testGrantTypes(GrantType.REFRESH_TOKEN);
    }

    @Test
    public void testTwo() throws ComponentInitializationException {
        this.testGrantTypes(GrantType.REFRESH_TOKEN, GrantType.IMPLICIT);
    }

    @Test
    public void testAll() throws ComponentInitializationException {
        this.testGrantTypes(GrantType.AUTHORIZATION_CODE, GrantType.IMPLICIT, GrantType.REFRESH_TOKEN);
    }

    protected void testGrantTypes(GrantType ... grantTypes) throws ComponentInitializationException {
        this.testGrantTypes(Collections.emptyList(), null, grantTypes);
    }

    protected void testGrantTypes(List<GrantType> ignoredTypes, String expectedEventId, GrantType ... grantTypes) throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setGrantTypes(new HashSet<GrantType>(List.of(grantTypes)));
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Event event = this.action.execute(this.requestCtx);
        if (expectedEventId != null) {
            ActionTestingSupport.assertEvent((Event)event, (String)expectedEventId);
            return;
        }
        Assert.assertNull((Object)event);
        Set resultTypes = result.getGrantTypes();
        Assert.assertNotNull((Object)resultTypes);
        int length = ignoredTypes == null ? grantTypes.length : grantTypes.length - ignoredTypes.size();
        Assert.assertEquals((int)resultTypes.size(), (int)length);
        for (GrantType grantType : grantTypes) {
            if (ignoredTypes.contains(grantType)) {
                Assert.assertFalse((boolean)resultTypes.contains(grantType));
                continue;
            }
            Assert.assertTrue((boolean)resultTypes.contains(grantType));
        }
    }
}

