/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Map;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddClientNameToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddClientNameToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddClientNameToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddClientNameToClientMetadata();
        this.action.initialize();
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddClientNameToClientMetadata();
    }

    @Test
    public void testNull() throws ComponentInitializationException {
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(new OIDCClientMetadata(), result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)result.getName());
        Assert.assertTrue((boolean)result.getNameEntries().isEmpty());
    }

    @Test
    public void testEmpty() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setName("");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)result.getName());
        Assert.assertTrue((boolean)result.getNameEntries().isEmpty());
    }

    @Test
    public void testNoTag() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        String name = "client name";
        request.setName("client name");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((String)result.getName(), (String)"client name");
        Map map = result.getNameEntries();
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals((String)((String)map.get(map.keySet().iterator().next())), (String)"client name");
    }

    @Test
    public void testTags() throws ComponentInitializationException, LangTagException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        String name1 = "client name";
        LangTag tag1 = new LangTag("en");
        String name2 = "asiakkaan nimi";
        LangTag tag2 = new LangTag("fi");
        request.setName("client name", tag1);
        request.setName("asiakkaan nimi", tag2);
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)result.getName());
        Map map = result.getNameEntries();
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((int)map.size(), (int)2);
        Assert.assertEquals((String)((String)map.get(tag1)), (String)"client name");
        Assert.assertEquals((String)((String)map.get(tag2)), (String)"asiakkaan nimi");
    }
}

