/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcClientAuthenticationFlowTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateGrantTest;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class TokenFlowTest
extends AbstractOidcClientAuthenticationFlowTest {
    public static final String FLOW_ID = "oidc/token";
    String redirectUri = "https://example.org/cb";
    String clientIdPkcePlain = "mockClientIdPKCEPlain";
    String clientIdPkcePlainUnforced = "mockClientIdPKCEPlainUnforced";
    String clientIdPkceS256 = "mockClientIdPKCES256";
    String clientIdPkcePlainPublic = "mockPublicClientIdPKCEPlain";
    String clientIdPkcePlainUnforcedPublic = "mockPublicClientIdPKCEPlainUnforced";
    String clientIdPkceS256Public = "mockPublicClientIdPKCES256";
    String clientIdCustomTokens = "mockClientIdCustomTokens";
    String clientIdRefreshTokenRotation = "mockClientIdRefreshTokenRotation";
    String codeVerifier = "9234567812345678123456781234567812345678123456781234567812345678";
    Scope scope = Scope.parse((String)"openid profile email offline_access");
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;
    @Autowired
    @Qualifier(value="shibboleth.oidc.RevocationCache")
    RevocationCache revocationCache;

    public TokenFlowTest() {
        super(FLOW_ID);
    }

    @AfterMethod
    public void removeMetadata() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
        this.removeMetadata(this.storageService, this.clientIdPkcePlain);
        this.removeMetadata(this.storageService, this.clientIdPkceS256);
        this.removeMetadata(this.storageService, this.clientIdCustomTokens);
        this.removeMetadata(this.storageService, this.clientIdRefreshTokenRotation);
    }

    @Test
    public void testNoClientId() throws IOException, ParseException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.redirectUri, "authorization_code", "mockCode", null));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testNoGrantType() throws IOException, ParseException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.redirectUri, null, "mockCode", this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testUntrustedClient() throws IOException, ParseException {
        this.setHttpFormRequest("POST", this.createRequestParameters(null, "authorization_code", "mockCode", this.clientId + "2"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testUnauthorizedGrant() throws IOException, ParseException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.redirectUri, "authorization_code", "mockCode", this.clientId));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testInvalidGrant() throws ParseException, IOException {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.redirectUri, "authorization_code", "mockCode", this.clientId));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
    }

    @Test(enabled=false)
    public void testNoScopes() throws Exception {
        this.setHttpFormRequest("POST", this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId), this.clientId));
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, null, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        AccessTokenResponse response = this.parseSuccessResponse(result, AccessTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    protected void initializeGrantAndRequest(String clientId, Map<String, String> requestParameters) throws IOException {
        this.initializeGrantAndRequest(clientId, requestParameters, true, null);
    }

    protected void initializeGrantAndRequest(String clientId, Map<String, String> requestParameters, boolean doBasicAuth, ClientAuthenticationMethod registeredMethod) throws IOException {
        this.setHttpFormRequest("POST", requestParameters);
        if (doBasicAuth) {
            this.setBasicAuth(clientId, this.clientSecret);
        }
        if (registeredMethod != null) {
            this.storeMetadata(this.storageService, clientId, this.clientSecret, this.scope, null, registeredMethod, new String[0]);
        } else {
            this.storeMetadata(this.storageService, clientId, this.clientSecret, this.scope, new String[0]);
        }
    }

    @Test
    public void testValidGrant() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId), this.clientId));
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getTokens().getRefreshToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidGrantWithCustomTokens() throws Exception {
        this.initializeGrantAndRequest(this.clientIdCustomTokens, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdCustomTokens), this.clientId));
        this.storeConsent(this.storageService, "jdoe", this.clientIdCustomTokens, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getTokens().getRefreshToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        IDTokenClaimsSet idToken = new IDTokenClaimsSet(response.getOIDCTokens().getIDToken().getJWTClaimsSet());
        Assert.assertNotNull((Object)idToken);
        Assert.assertNotNull((Object)idToken.getStringClaim("custom_id_token_claim"));
        Assert.assertEquals((String)idToken.getStringClaim("custom_id_token_claim"), (String)"value1");
        AccessTokenClaimsSet accessToken = AccessTokenClaimsSet.parse((String)response.getTokens().getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        String atCustomAtClaim = accessToken.getClaimsSet().getStringClaim("custom_access_token_claim");
        String atCustomRtClaim = accessToken.getClaimsSet().getStringClaim("custom_refresh_token_claim");
        Assert.assertNotNull((Object)atCustomAtClaim);
        Assert.assertEquals((String)atCustomAtClaim, (String)"value2");
        Assert.assertNull((Object)atCustomRtClaim);
        RefreshTokenClaimsSet refreshToken = RefreshTokenClaimsSet.parse((String)response.getTokens().getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        String rtCustomAtClaim = refreshToken.getClaimsSet().getStringClaim("custom_access_token_claim");
        String rtCustomRtClaim = refreshToken.getClaimsSet().getStringClaim("custom_refresh_token_claim");
        Assert.assertNotNull((Object)rtCustomRtClaim);
        Assert.assertEquals((String)rtCustomRtClaim, (String)"value3");
        Assert.assertNull((Object)rtCustomAtClaim);
    }

    @Test
    public void testValidGrantWithWrongRegisteredAuthType() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId), this.clientId), true, ClientAuthenticationMethod.NONE);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
    }

    @Test
    public void testValidGrantWithoutAuthentication() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId), this.clientId), false, ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testValidGrantRefreshTokensDisabledInSSOProfile() throws Exception {
        String clientId = "mockClientIdNoRefreshTokensInSSOProfile";
        this.initializeGrantAndRequest("mockClientIdNoRefreshTokensInSSOProfile", this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode("mockClientIdNoRefreshTokensInSSOProfile"), "mockClientIdNoRefreshTokensInSSOProfile"));
        this.storeConsent(this.storageService, "jdoe", "mockClientIdNoRefreshTokensInSSOProfile", "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNull((Object)response.getTokens().getRefreshToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidGrantRefreshTokensDisabledInTokenProfile() throws Exception {
        String clientId = "mockClientIdNoRefreshTokensInTokenProfile";
        this.initializeGrantAndRequest("mockClientIdNoRefreshTokensInTokenProfile", this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode("mockClientIdNoRefreshTokensInTokenProfile"), "mockClientIdNoRefreshTokensInTokenProfile"));
        this.storeConsent(this.storageService, "jdoe", "mockClientIdNoRefreshTokensInTokenProfile", "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNull((Object)response.getTokens().getRefreshToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidGrantWithRequestedScope() throws Exception {
        Map<String, String> params = this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId), this.clientId);
        params.put("scope", "openid profile");
        this.initializeGrantAndRequest(this.clientId, params);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        AccessTokenClaimsSet token = AccessTokenClaimsSet.parse((String)response.getTokens().getAccessToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertTrue((boolean)token.getScope().contains("openid"));
        Assert.assertTrue((boolean)token.getScope().contains("profile"));
        Assert.assertFalse((boolean)token.getScope().contains("email"));
    }

    @Test
    public void testValidLegacyGrant() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildLegacyAuthorizationCode(this.clientId, new String[0]), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, false);
    }

    @Test
    public void testValidLegacyConsentGrant() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildLegacyAuthorizationCode(this.clientId, "mail"), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, true);
    }

    protected void validateConsentFromAccessToken(OIDCTokenResponse response, boolean value) throws Exception {
        AccessTokenClaimsSet claims = this.unwrapAccessToken(response);
        Assert.assertTrue((boolean)claims.getClaimsSet().getClaims().containsKey("cnsnt"));
        Assert.assertEquals((boolean)claims.getClaimsSet().getBooleanClaim("cnsnt"), (boolean)value);
        Assert.assertEquals((boolean)claims.isConsentEnabled(), (boolean)value);
    }

    @Test
    public void testValidGrantSaml() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdSaml), this.clientIdSaml));
        this.setBasicAuth(this.clientIdSaml, this.clientSecretSaml);
        this.storeConsent(this.storageService, "jdoe", this.clientIdSaml, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        JWT idToken = response.getOIDCTokens().getIDToken();
        Assert.assertNotNull((Object)idToken);
        Assert.assertEquals((Object)idToken.getJWTClaimsSet().getClaim("email"), (Object)"jdoe@example.org");
    }

    protected String buildAuthorizationCode(String clientId) throws Exception {
        return this.buildAuthorizationCode(clientId, null);
    }

    protected String buildAuthorizationCode(String clientId, String verifier) throws Exception {
        return this.buildAuthorizationCode(clientId, verifier, null, null, null);
    }

    protected String buildAuthorizationCode(String clientId, String verifier, JSONObject deliveryClaims, JSONObject deliveryClaimsIDToken, JSONObject deliveryClaimsUserInfo) throws Exception {
        return ValidateGrantTest.buildAuthorizationCode(clientId, "https://op.example.org", "jdoe", "mock", this.redirectUri, verifier, deliveryClaims, deliveryClaimsIDToken, deliveryClaimsUserInfo, "openid profile email offline_access").toString();
    }

    protected String buildLegacyAuthorizationCode(String clientId, String ... consentedClaims) throws Exception {
        String json = this.buildJsonForLegacyToken("jdoe", clientId, Scope.parse((String)"openid email"), "ac", consentedClaims);
        return new AuthorizationCode(this.getDataSealer().wrap(json, Instant.now().plusSeconds(30L))).getValue();
    }

    protected String buildLegacyRefreshToken(String clientId, String ... consentedClaims) throws Exception {
        String json = this.buildJsonForLegacyToken("jdoe", clientId, Scope.parse((String)"openid email"), "rf", consentedClaims);
        return new RefreshToken(this.getDataSealer().wrap(json, Instant.now().plusSeconds(30L))).getValue();
    }

    protected String buildRefreshToken(String clientId, String id, String rootId, String ... consentedClaims) throws Exception {
        TokenClaimsSet acClaims = ValidateGrantTest.buildTokenClaimsSet(clientId, "https://op.example.org", "jdoe", "mock", this.redirectUri, null, null, null, null, this.scope.toString());
        RefreshTokenClaimsSet rtClaims = (RefreshTokenClaimsSet)new RefreshTokenClaimsSet.Builder(acClaims, Instant.now(), Instant.now().plus(Duration.ofHours(1L))).setRootTokenIdentifier(rootId).setJWTID(id).build();
        return new RefreshToken(rtClaims.serialize(new ValidateGrantTest().getDataSealer())).getValue();
    }

    @Override
    @Test
    public void testValidSecretJWT() throws Exception {
        ClientSecretJWT clientAuth = this.buildSecretJwtAuth(this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication((JWTAuthentication)clientAuth, JWSAlgorithm.HS256);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidSecretJWTNoAlg() throws Exception {
        ClientSecretJWT clientAuth = this.buildSecretJwtAuth(this.clientSecret);
        FlowExecutionResult result = this.launchWithJwtAuthentication((JWTAuthentication)clientAuth, null);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidGrantValidRequestMissingPlainPKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlain, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlain, this.plainVerifier()), this.clientIdPkcePlain));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "InvalidMessage");
    }

    @Test
    public void testValidGrantInvalidUnforcedPlainPKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlainUnforced, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlainUnforced, this.plainVerifier()), this.clientIdPkcePlainUnforced, null, null, this.codeVerifier + "invalid"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "MessageAuthenticationError");
    }

    @Test
    public void testValidGrantInvalidPlainPKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlain, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlain, this.plainVerifier()), this.clientIdPkcePlain, null, null, this.codeVerifier + "invalid"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "MessageAuthenticationError");
    }

    @Test
    public void testValidGrantValidPlainPKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlain, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlain, this.plainVerifier()), this.clientIdPkcePlain, null, null, this.codeVerifier));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testValidGrantValidPlainPKCE_publicClient() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlainPublic, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlainPublic, this.plainVerifier()), this.clientIdPkcePlainPublic, null, null, this.codeVerifier), false, ClientAuthenticationMethod.NONE);
        this.storeConsent(this.storageService, "jdoe", this.clientIdPkcePlainPublic, "mail");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getTokens().getRefreshToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }

    @Test
    public void testValidGrantValidUnforcedPlainPKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlainUnforced, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlainUnforced, this.plainVerifier()), this.clientIdPkcePlainUnforced, null, null, this.codeVerifier));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testValidGrantValidUnforcedPlainPKCE_publicClient() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlainUnforcedPublic, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlainUnforcedPublic, this.plainVerifier()), this.clientIdPkcePlainUnforcedPublic, null, null, this.codeVerifier), false, ClientAuthenticationMethod.NONE);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testValidGrantValidRequestMissingS256PKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkceS256, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkceS256, this.s256Verifier()), this.clientIdPkceS256));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "InvalidMessage");
    }

    @Test
    public void testValidGrantInvalidUnforcedS256PKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkcePlainUnforced, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkcePlainUnforced, this.s256Verifier()), this.clientIdPkcePlainUnforced, null, "S256", this.codeVerifier + "invalid"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "MessageAuthenticationError");
    }

    @Test
    public void testValidGrantInvalidS256PKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkceS256, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkceS256, this.s256Verifier()), this.clientIdPkceS256, null, "S256", this.codeVerifier + "invalid"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "MessageAuthenticationError");
    }

    @Test
    public void testValidGrantValidS256PKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkceS256, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkceS256, this.s256Verifier()), this.clientIdPkceS256, null, "S256", this.codeVerifier));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testValidGrantValidS256PKCE_publicClient() throws Exception {
        this.initializeGrantAndRequest(this.clientIdPkceS256Public, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientIdPkceS256Public, this.s256Verifier()), this.clientIdPkceS256Public, null, "S256", this.codeVerifier), false, ClientAuthenticationMethod.NONE);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testValidGrantValidUnforcedS256PKCE() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId, this.s256Verifier()), this.clientId, null, "S256", this.codeVerifier));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
    }

    @Test
    public void testInvalidSecretJWT() throws Exception {
        ClientSecretJWT clientAuth = this.buildSecretJwtAuth(this.clientSecret + "invalid");
        FlowExecutionResult result = this.launchWithJwtAuthentication((JWTAuthentication)clientAuth, JWSAlgorithm.HS256);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testValidGrantWrappedClaimsUI() throws Exception {
        String claimName = "name";
        String claimValue = "John Doe";
        JSONObject claimsUI = new JSONObject();
        claimsUI.put((Object)"name", (Object)"John Doe");
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId, null, null, null, claimsUI), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessTokenClaimsSet claimsSet = this.unwrapAccessToken(response);
        Assert.assertNotNull((Object)claimsSet);
        ClaimsSet dlClaimsSet = claimsSet.getUserinfoDeliveryClaims();
        Assert.assertNotNull((Object)dlClaimsSet);
        Assert.assertEquals((Object)dlClaimsSet.getClaim("name"), (Object)"John Doe");
        Assert.assertNull((Object)claimsSet.getDeliveryClaims().getClaim("name"));
        Assert.assertNull((Object)claimsSet.getIDTokenDeliveryClaims());
    }

    @Test
    public void testValidGrantWrappedClaims() throws Exception {
        String claimName = "name";
        String claimValue = "John Doe";
        JSONObject claims = new JSONObject();
        claims.put((Object)"name", (Object)"John Doe");
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "authorization_code", this.buildAuthorizationCode(this.clientId, null, claims, null, null), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessTokenClaimsSet claimsSet = this.unwrapAccessToken(response);
        Assert.assertNotNull((Object)claimsSet);
        ClaimsSet dlClaimsSet = claimsSet.getDeliveryClaims();
        Assert.assertNotNull((Object)dlClaimsSet);
        Assert.assertEquals((Object)dlClaimsSet.getClaim("name"), (Object)"John Doe");
        Assert.assertNull((Object)claimsSet.getUserinfoDeliveryClaims().getClaim("name"));
        Assert.assertNull((Object)claimsSet.getIDTokenDeliveryClaims());
    }

    @Test
    public void testValidLegacyRefreshTokenGrant() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildLegacyRefreshToken(this.clientId, new String[0]), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, false);
    }

    @Test
    public void testValidLegacyConsentRefreshTokenGrant() throws Exception {
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildLegacyRefreshToken(this.clientId, "mail"), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, true);
    }

    @Test
    public void testValidRefreshTokenGrant() throws Exception {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        this.initializeGrantAndRequest(this.clientId, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildRefreshToken(this.clientId, id, rootId, new String[0]), this.clientId));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, false);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testValidRefreshTokenGrantRefreshTokenRotation() throws Exception {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        this.initializeGrantAndRequest(this.clientIdRefreshTokenRotation, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildRefreshToken(this.clientIdRefreshTokenRotation, id, rootId, new String[0]), this.clientIdRefreshTokenRotation));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        AccessToken accessToken = response.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
        this.validateConsentFromAccessToken(response, false);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testRevokedRefreshTokenGrantRefreshTokenRotation() throws Exception {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        Assert.assertTrue((boolean)this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        this.initializeGrantAndRequest(this.clientIdRefreshTokenRotation, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildRefreshToken(this.clientIdRefreshTokenRotation, id, rootId, new String[0]), this.clientIdRefreshTokenRotation));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testRevokedChainInRefreshTokenGrant() throws Exception {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        Assert.assertTrue((boolean)this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
        this.initializeGrantAndRequest(this.clientIdRefreshTokenRotation, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildRefreshToken(this.clientIdRefreshTokenRotation, id, rootId, new String[0]), this.clientIdRefreshTokenRotation));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testRevokedChainViaJtiInRefreshTokenGrant() throws Exception {
        String id = this.idGenerator.generateIdentifier();
        Assert.assertTrue((boolean)this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, id));
        this.initializeGrantAndRequest(this.clientIdRefreshTokenRotation, this.createRequestParameters(this.redirectUri, "refresh_token", this.buildRefreshToken(this.clientIdRefreshTokenRotation, id, null, new String[0]), this.clientIdRefreshTokenRotation));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, id));
    }

    private AccessTokenClaimsSet unwrapAccessToken(OIDCTokenResponse tokenResponse) {
        AccessToken accessToken = tokenResponse.getTokens().getAccessToken();
        Assert.assertNotNull((Object)accessToken);
        try {
            return AccessTokenClaimsSet.parse((String)accessToken.getValue(), (DataSealer)this.getDataSealer());
        }
        catch (ParseException | DataSealerException e) {
            return null;
        }
    }

    private String plainVerifier() {
        return "plain" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.PLAIN, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue();
    }

    private String s256Verifier() {
        return "S256" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.S256, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue();
    }

    protected FlowExecutionResult launchWithJwtAuthentication(JWTAuthentication authnMethod, JWSAlgorithm algorithm) throws Exception {
        return this.launchWithJwtAuthentication(authnMethod, algorithm, null);
    }

    protected FlowExecutionResult launchWithJwtAuthentication(JWTAuthentication authnMethod, JWSAlgorithm algorithm, String requestedScope) throws Exception {
        String code = ValidateGrantTest.buildAuthorizationCode(this.clientId, "https://op.example.org", "jdoe", "mock", this.redirectUri, this.scope.toString()).toString();
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, JWSAlgorithm.HS256, ClientAuthenticationMethod.CLIENT_SECRET_JWT, new String[0]);
        Map<String, String> requestParameters = this.createRequestParameters(this.redirectUri, "authorization_code", code, this.clientId);
        if (requestedScope != null) {
            requestParameters.put("scope", requestedScope);
        }
        this.populateClientAssertionParams(requestParameters, authnMethod);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    @Override
    protected FlowExecutionResult launchWithJwtAuthentication(SignedJWT jwt, JWSAlgorithm algorithm, ClientAuthenticationMethod method) throws Exception {
        String code = ValidateGrantTest.buildAuthorizationCode(this.clientId, "https://op.example.org", "jdoe", "mock", this.redirectUri, this.scope.toString()).toString();
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)method)) {
            this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, algorithm, method, new String[0]);
        } else {
            this.storeMetadata(this.storageService, this.clientId, null, this.scope, algorithm, method, null, this.rsaPublicKey, new String[0]);
        }
        Map<String, String> requestParameters = this.createRequestParameters(this.redirectUri, "authorization_code", code, this.clientId);
        this.populateClientAssertionParams(requestParameters, jwt);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    protected Map<String, String> createRequestParameters(String redirectUri, String grantType, String code, String clientId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addNonNullValue(parameters, "redirect_uri", redirectUri);
        this.addNonNullValue(parameters, "grant_type", grantType);
        if ("refresh_token".equals(grantType)) {
            this.addNonNullValue(parameters, "refresh_token", code);
        } else {
            this.addNonNullValue(parameters, "code", code);
        }
        this.addNonNullValue(parameters, "client_id", clientId);
        return parameters;
    }

    protected Map<String, String> createRequestParameters(String redirectUri, String grantType, String code, String clientId, String codeChallenge, String codeChallengeMethod, String codeVerifier) {
        Map<String, String> parameters = this.createRequestParameters(redirectUri, grantType, code, clientId);
        this.addNonNullValue(parameters, "code_challenge", codeChallenge);
        this.addNonNullValue(parameters, "code_challenge_method", codeChallengeMethod);
        this.addNonNullValue(parameters, "code_verifier", codeVerifier);
        return parameters;
    }

    private void addNonNullValue(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    @Override
    protected Pair<String, String> getErrorDetaisForJWTValidation() {
        return new Pair((Object)"invalid_client", (Object)"Client authentication failed");
    }

    @Override
    protected void assertSuccessResponse(FlowExecutionResult result) {
        OIDCTokenResponse response = this.parseSuccessResponse(result, OIDCTokenResponse.class);
        Assert.assertNotNull((Object)response.getTokens().getAccessToken());
        Assert.assertNotNull((Object)response.getOIDCTokens().getIDToken());
    }
}

