/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeySetFlowTest
extends AbstractOidcFlowTest {
    public static final String FLOW_ID = "oidc/keyset";
    Resource rsaSigKey = new FileSystemResource("src/test/resources/credentials/idp-signing-rs.jwk");
    Resource rsaEncKey = new FileSystemResource("src/test/resources/credentials/idp-encryption-rsa.jwk");
    Resource ecSigKey = new FileSystemResource("src/test/resources/credentials/idp-signing-es.jwk");

    public KeySetFlowTest() {
        super(FLOW_ID);
    }

    @Test
    public void test() throws ParseException, IOException, java.text.ParseException {
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Response response = this.parseResponse(result);
        Assert.assertTrue((boolean)response.indicatesSuccess());
        JWKSet jwkSet = JWKSet.parse((String)response.toHTTPResponse().getContent());
        List keys = jwkSet.getKeys();
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((int)keys.size(), (int)3);
        JWK rsaSigJwk = JWK.parse((String)IOUtils.toString((InputStream)this.rsaSigKey.getInputStream(), (String)"UTF-8"));
        Assert.assertTrue((boolean)this.listContainsPublicJwk(keys, rsaSigJwk));
        JWK rsaEncJwk = JWK.parse((String)IOUtils.toString((InputStream)this.rsaEncKey.getInputStream(), (String)"UTF-8"));
        Assert.assertTrue((boolean)this.listContainsPublicJwk(keys, rsaEncJwk));
        JWK ecSigJwk = JWK.parse((String)IOUtils.toString((InputStream)this.ecSigKey.getInputStream(), (String)"UTF-8"));
        Assert.assertTrue((boolean)this.listContainsPublicJwk(keys, ecSigJwk));
    }

    protected boolean listContainsPublicJwk(List<JWK> list, JWK jwk) {
        for (JWK item : list) {
            Assert.assertEquals((String)item.toJSONString(), (String)item.toPublicJWK().toJSONString());
            if (!jwk.getKeyType().equals((Object)item.getKeyType()) || !jwk.getKeyUse().equals((Object)item.getKeyUse()) || !jwk.getKeyID().equals(item.getKeyID())) continue;
            if (jwk.getKeyType().equals((Object)KeyType.EC)) {
                Assert.assertNull(item.toJSONObject().get("d"));
                if (!this.jsonValueEquals(jwk, item, "crv") || !this.jsonValueEquals(jwk, item, "x") || !this.jsonValueEquals(jwk, item, "y")) continue;
                return true;
            }
            if (!jwk.getKeyType().equals((Object)KeyType.RSA)) continue;
            Assert.assertNull(item.toJSONObject().get("d"));
            if (!this.jsonValueEquals(jwk, item, "e") || !this.jsonValueEquals(jwk, item, "n")) continue;
            return true;
        }
        return false;
    }

    protected boolean jsonValueEquals(JWK first, JWK another, String key) {
        return first.toJSONObject().get(key).equals(another.toJSONObject().get(key));
    }
}

