/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenIntrospectionErrorResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcClientAuthenticationFlowTest;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class IntrospectionFlowTest
extends AbstractOidcClientAuthenticationFlowTest {
    public static final String FLOW_ID = "oauth2/introspection";
    private Scope scope = Scope.parse((String)"openid profile email");
    @Autowired
    @Qualifier(value="testbed.DefaultRSSigningCredential")
    private JWKCredential signingKey = null;
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    private StorageService storageService;
    @Autowired
    @Qualifier(value="shibboleth.oidc.RevocationCache")
    private RevocationCache revocationCache;

    public IntrospectionFlowTest() {
        super(FLOW_ID);
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
    }

    @Test
    public void testUntrustedClient() throws NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret + "bad");
        this.setHttpFormRequest("POST", Collections.singletonMap("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testFailedAuthentication() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret + "X");
        this.setHttpFormRequest("POST", Collections.singletonMap("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionErrorResponse resp = (TokenIntrospectionErrorResponse)this.parseErrorResponse(result);
        Assert.assertEquals((String)resp.getErrorObject().getCode(), (String)"invalid_client");
    }

    @Test
    public void testInvalidMessage() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Collections.singletonMap("token_not", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
    }

    @Test
    public void testFailureUnverified() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId + "2", "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testSuccessUnverified() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertTrue((boolean)resp.isActive());
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertEquals((Set)resp.getScope(), (Set)Scope.parse((String)"openid"));
        Assert.assertNull((Object)resp.getAudience());
    }

    @Test
    public void testSuccess() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertTrue((boolean)resp.isActive());
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertEquals((Set)resp.getScope(), (Set)Scope.parse((String)"openid"));
        Assert.assertNull((Object)resp.getAudience());
    }

    @Test
    public void testRevokedSingleToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String rootId = this.idGenerator.generateIdentifier();
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jti);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid"), null, jti, rootId).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testRevokedChain() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String rootId = this.idGenerator.generateIdentifier();
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, rootId);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid"), null, jti, rootId).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testRevokedChainViaJti() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, jti);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildToken(this.clientId, "sub", Scope.parse((String)"openid"), null, jti, null).toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testSuccessWithSamlMetadata() throws NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientIdSaml, this.clientSecretSaml);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", this.buildToken(this.clientIdSaml, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientIdSaml);
        Assert.assertTrue((boolean)resp.isActive());
    }

    @Test
    public void testSuccessWithLegacyToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", this.buildLegacyToken(this.clientId, "sub", Scope.parse((String)"openid"), new String[0]).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertTrue((boolean)resp.isActive());
    }

    @Test
    public void testSuccessWithLegacyConsentToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", this.buildLegacyToken(this.clientId, "sub", Scope.parse((String)"openid"), "mail").toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertTrue((boolean)resp.isActive());
    }

    @Test
    public void testSuccessJWTNoAudience() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(this.clientId, "sub", this.scope, null, this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertTrue((boolean)resp.isActive());
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertEquals((Set)resp.getScope(), (Set)this.scope);
        Assert.assertNull((Object)resp.getAudience());
    }

    @Test
    public void testSuccessJWTAudience() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken("https://sp2.example.org", "sub", this.scope, List.of("https://sp.example.org", this.clientId), this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertTrue((boolean)resp.isActive());
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)"https://sp2.example.org");
        Assert.assertEquals((Set)resp.getScope(), (Set)this.scope);
        Assert.assertEquals((Collection)resp.getAudience(), List.of(new Audience("https://sp.example.org"), new Audience(this.clientId)));
    }

    @Test
    public void testFailureJWTExpired() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        AccessTokenClaimsSet claims = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID(this.clientId)).setIssuer("https://op.example.org").setSubject(this.clientId).setIssuedAt(Instant.now().minusSeconds(300L)).setNotBefore(Instant.now().minusSeconds(300L)).setExpiresAt(Instant.now().minusSeconds(200L)).setAuthenticationTime(Instant.now()).setScope(this.scope).build();
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(claims, this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testFailureJWTNotYetValid() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        AccessTokenClaimsSet claims = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID(this.clientId)).setIssuer("https://op.example.org").setSubject(this.clientId).setIssuedAt(Instant.now()).setNotBefore(Instant.now().plusSeconds(300L)).setExpiresAt(Instant.now().plusSeconds(1800L)).setAuthenticationTime(Instant.now()).setScope(this.scope).build();
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(claims, this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testFailureJWTNotAuthorized() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken("https://sp3.example.org", "sub", this.scope, List.of("https://sp.example.org", "https://sp2.example.org"), this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testFailureJWTWrongKey() throws JOSEException, IOException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(this.clientId, "sub", this.scope, null, this.rsaPrivateKey, "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Test
    public void testUnidentifiedToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", "unknowntoken"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertNull((Object)resp.getClientID());
        Assert.assertFalse((boolean)resp.isActive());
    }

    @Override
    protected FlowExecutionResult launchWithJwtAuthentication(SignedJWT jwt, JWSAlgorithm algorithm, ClientAuthenticationMethod method) throws Exception {
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)method)) {
            this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, algorithm, method, new String[0]);
        } else {
            this.storeMetadata(this.storageService, this.clientId, null, this.scope, algorithm, method, null, this.rsaPublicKey, new String[0]);
        }
        String accessToken = this.buildToken(this.clientId, "sub", this.scope).toJSONObject().getAsString("access_token");
        Map<String, String> requestParameters = this.createRequestParameters(accessToken, this.clientId);
        this.populateClientAssertionParams(requestParameters, jwt);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    protected Map<String, String> createRequestParameters(String token, String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("token", token);
        result.put("client_id", id);
        return result;
    }

    @Override
    protected Pair<String, String> getErrorDetaisForJWTValidation() {
        return new Pair((Object)"invalid_client", (Object)"Client authentication failed");
    }

    @Override
    protected void assertSuccessResponse(FlowExecutionResult result) {
        TokenIntrospectionSuccessResponse resp = this.parseSuccessResponse(result, TokenIntrospectionSuccessResponse.class);
        Assert.assertTrue((boolean)resp.isActive());
        Assert.assertEquals((String)resp.getClientID().getValue(), (String)this.clientId);
        Assert.assertEquals((Set)resp.getScope(), (Set)this.scope);
        Assert.assertNull((Object)resp.getAudience());
    }
}

