/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.time.Instant;
import java.util.Collection;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealerException;

public class AbstractOidcApiFlowTest
extends AbstractOidcFlowTest {
    protected AbstractOidcApiFlowTest(String flowId) {
        super(flowId);
    }

    protected BearerAccessToken buildToken(String clientId, String subject, Scope scope) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        return this.buildToken(clientId, subject, scope, null);
    }

    protected BearerAccessToken buildLegacyToken(String clientId, String subject, Scope scope, String ... consentedClaims) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        return this.buildLegacyToken(clientId, subject, scope, (ClaimsSet)null, consentedClaims);
    }

    protected BearerAccessToken buildToken(String clientId, String subject, Scope scope, ClaimsSet userInfoDeliverySet) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        return this.buildToken(clientId, subject, scope, userInfoDeliverySet, null, null);
    }

    protected BearerAccessToken buildToken(String clientId, String subject, Scope scope, ClaimsSet userInfoDeliverySet, String id, String rootId) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        String jti = id == null ? this.idGenerator.generateIdentifier() : id;
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(jti).setClientID(new ClientID(clientId)).setIssuer("https://op.example.org").setPrincipal("jdoe").setSubject(subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(30L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("https://example.org/cb")).setScope(scope).setDlClaimsUI(userInfoDeliverySet).setRootTokenIdentifier(rootId).build();
        return new BearerAccessToken(claims.serialize(BaseOIDCResponseActionTest.initializeDataSealer()));
    }

    protected RefreshToken buildRefreshToken(String clientId, String subject, Scope scope, ClaimsSet userInfoDeliverySet, String id, String rootId) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        String jti = id == null ? this.idGenerator.generateIdentifier() : id;
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(jti).setClientID(new ClientID(clientId)).setIssuer("https://op.example.org").setPrincipal("jdoe").setSubject(subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(30L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("https://example.org/cb")).setScope(scope).setDlClaimsUI(userInfoDeliverySet).setRootTokenIdentifier(rootId).build();
        return new RefreshToken(claims.serialize(BaseOIDCResponseActionTest.initializeDataSealer()));
    }

    protected BearerAccessToken buildLegacyToken(String clientId, String subject, Scope scope, ClaimsSet userInfoDeliverySet, String ... consentedClaims) throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        String json = this.buildJsonForLegacyToken(subject, clientId, scope, "at", consentedClaims);
        return new BearerAccessToken(BaseOIDCResponseActionTest.initializeDataSealer().wrap(json, Instant.now().plusSeconds(30L)));
    }

    protected BearerAccessToken buildJWTToken(String clientId, String subject, Scope scope, Collection<String> audience, PrivateKey key, String alg) throws JOSEException {
        AccessTokenClaimsSet claims = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID(clientId)).setIssuer("https://op.example.org").setSubject(subject).setIssuedAt(Instant.now()).setNotBefore(Instant.now().minusSeconds(300L)).setExpiresAt(Instant.now().plusSeconds(1800L)).setAuthenticationTime(Instant.now()).setScope(scope).setAudience(audience).build();
        return this.buildJWTToken(claims, key, alg);
    }

    protected BearerAccessToken buildJWTToken(AccessTokenClaimsSet claims, PrivateKey key, String alg) throws JOSEException {
        if (key != null) {
            JWSAlgorithm jwsAlgorithm = new JWSAlgorithm(alg);
            JWSSigner signer = this.getSigner(key, (Algorithm)jwsAlgorithm);
            JWSHeader.Builder headerBuilder = new JWSHeader.Builder(jwsAlgorithm).type(new JOSEObjectType("at+jwt"));
            SignedJWT jwt = new SignedJWT(headerBuilder.build(), claims.getClaimsSet());
            jwt.sign(signer);
            return new BearerAccessToken(jwt.serialize());
        }
        return new BearerAccessToken(new PlainJWT(claims.getClaimsSet()).serialize());
    }

    private JWSSigner getSigner(PrivateKey key, Algorithm jwsAlgorithm) throws JOSEException {
        if (JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm)) {
            return new ECDSASigner((ECPrivateKey)key);
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            return new RSASSASigner(key);
        }
        throw new JOSEException("Unsupported algorithm " + jwsAlgorithm.getName());
    }
}

