/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl.SetEntityIdToSAMLPeerEntityContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetEntityIdToSAMLPeerEntityContextTest {
    private SetEntityIdToSAMLPeerEntityContext handler;
    private MessageContext messageCtx;
    private String clientId = "mockClientId";

    @BeforeMethod
    public void setup() {
        this.handler = new SetEntityIdToSAMLPeerEntityContext();
    }

    public void initialize(SAMLPeerEntityContext entityContext, Function<MessageContext, ClientID> clientIdLookupStrategy) throws ComponentInitializationException {
        this.handler.setClientIDLookupStrategy(clientIdLookupStrategy);
        this.handler.initialize();
        this.messageCtx = new MessageContext();
        if (entityContext != null) {
            this.messageCtx.addSubcontext((BaseContext)entityContext);
        }
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setClientIDLookupStrategy_shouldThrowIfGivenNull() {
        this.handler.setClientIDLookupStrategy(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void setClientIDLookupStrategy_shouldThrowIfCalledAfterInitialization() throws ComponentInitializationException {
        this.handler.initialize();
        this.handler.setClientIDLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setEntityContextClass_shouldThrowIfGivenNull() {
        this.handler.setEntityContextClass(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void setEntityContextClass_shouldThrowIfCalledAfterInitialization() throws ComponentInitializationException {
        this.handler.initialize();
        this.handler.setEntityContextClass(null);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void execute_shouldSetInvalidMsgEventIfNoEntityContext() throws ComponentInitializationException, MessageHandlerException {
        this.initialize(null, this.mockClientIdLookupStrategy(this.clientId));
        this.handler.invoke(this.messageCtx);
    }

    @Test
    public void execute_shouldSetNullClientIdWhenLookupReturnsNull() throws ComponentInitializationException, MessageHandlerException {
        this.initialize(new SAMLPeerEntityContext(), this.mockClientIdLookupStrategy(null));
        this.handler.invoke(this.messageCtx);
        SAMLPeerEntityContext entityCtx = (SAMLPeerEntityContext)this.messageCtx.getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNull((Object)entityCtx.getEntityId());
    }

    @Test
    public void execute_shouldSetClientIdWhenPrequisitesMet() throws ComponentInitializationException, MessageHandlerException {
        this.initialize(new SAMLPeerEntityContext(), this.mockClientIdLookupStrategy(this.clientId));
        this.handler.invoke(this.messageCtx);
        SAMLPeerEntityContext entityCtx = (SAMLPeerEntityContext)this.messageCtx.getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertEquals((String)entityCtx.getEntityId(), (String)this.clientId);
    }

    protected Function<MessageContext, ClientID> mockClientIdLookupStrategy(String clientID) {
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((ClientID)function.apply((MessageContext)Mockito.any()))).thenReturn((Object)(clientID == null ? null : new ClientID(clientID)));
        return function;
    }
}

