/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.plugin.oidc.op.authn.impl.ExtractClientAuthenticationFromRequest;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractClientAuthenticationFromRequestTest {
    private ClientID clientId;
    private Secret clientSecret;
    private URI endpointUri;
    private RSAPrivateKey rsaPrivateKey;
    private RSAPublicKey rsaPublicKey;
    private ExtractClientAuthenticationFromRequest action;
    private RequestContext rc;
    private ProfileRequestContext prc;

    @BeforeClass
    public void initKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        this.rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
    }

    @BeforeMethod
    public void init() throws URISyntaxException, ComponentInitializationException {
        this.clientId = new ClientID("mockId");
        this.clientSecret = new Secret("secret1234567890secret1234567890secret1234567890");
        this.endpointUri = new URI("https://mock.example.org/");
        this.action = new ExtractClientAuthenticationFromRequest();
        this.action.initialize();
    }

    protected void initializeRequestCtx(ClientAuthenticationMethod method) throws JOSEException, ComponentInitializationException {
        Object clientAuth = method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) ? new ClientSecretBasic(this.clientId, this.clientSecret) : (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST) ? new ClientSecretPost(this.clientId, this.clientSecret) : (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) ? new ClientSecretJWT(this.clientId, this.endpointUri, JWSAlgorithm.HS256, this.clientSecret) : (method.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT) ? new PrivateKeyJWT(this.clientId, this.endpointUri, JWSAlgorithm.RS256, this.rsaPrivateKey, null, null) : null)));
        AuthorizationCodeGrant authzGrant = new AuthorizationCodeGrant(new AuthorizationCode(), null);
        this.rc = new RequestContextBuilder().setInboundMessage((Object)new TokenRequest(null, (ClientAuthentication)clientAuth, (AuthorizationGrant)authzGrant)).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.prc.addSubcontext((BaseContext)new AuthenticationContext());
    }

    @Test
    public void testNoAuthnContext() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.prc.removeSubcontext(AuthenticationContext.class);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)e, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testBasic() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
        OAuth2ClientAuthenticationContext oauth = (OAuth2ClientAuthenticationContext)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getSubcontext(OAuth2ClientAuthenticationContext.class);
        Assert.assertNotNull((Object)oauth);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getClientID(), (Object)this.clientId);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getMethod(), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        UsernamePasswordContext up = (UsernamePasswordContext)oauth.getParent().getSubcontext(UsernamePasswordContext.class);
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getUsername(), (String)this.clientId.getValue());
        Assert.assertEquals((String)up.getPassword(), (String)this.clientSecret.getValue());
    }

    @Test
    public void testPost() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
        OAuth2ClientAuthenticationContext oauth = (OAuth2ClientAuthenticationContext)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getSubcontext(OAuth2ClientAuthenticationContext.class);
        Assert.assertNotNull((Object)oauth);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getClientID(), (Object)this.clientId);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getMethod(), (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        UsernamePasswordContext up = (UsernamePasswordContext)oauth.getParent().getSubcontext(UsernamePasswordContext.class);
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getUsername(), (String)this.clientId.getValue());
        Assert.assertEquals((String)up.getPassword(), (String)this.clientSecret.getValue());
    }

    @Test
    public void testSecretJwt() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
        OAuth2ClientAuthenticationContext oauth = (OAuth2ClientAuthenticationContext)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getSubcontext(OAuth2ClientAuthenticationContext.class);
        Assert.assertNotNull((Object)oauth);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getClientID(), (Object)this.clientId);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getMethod(), (Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        UsernamePasswordContext up = (UsernamePasswordContext)oauth.getParent().getSubcontext(UsernamePasswordContext.class);
        Assert.assertNull((Object)up);
    }

    @Test
    public void testPrivateKeyJwt() throws Exception {
        this.initializeRequestCtx(ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        Event e = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)e);
        OAuth2ClientAuthenticationContext oauth = (OAuth2ClientAuthenticationContext)((AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class)).getSubcontext(OAuth2ClientAuthenticationContext.class);
        Assert.assertNotNull((Object)oauth);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getClientID(), (Object)this.clientId);
        Assert.assertEquals((Object)oauth.getClientAuthentication().getMethod(), (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        UsernamePasswordContext up = (UsernamePasswordContext)oauth.getParent().getSubcontext(UsernamePasswordContext.class);
        Assert.assertNull((Object)up);
    }
}

