/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.attribute.filter.matcher.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.plugin.oidc.op.attribute.filter.matcher.impl.AttributeInOIDCRequestedClaimsMatcher;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeInOIDCRequestedClaimsMatcherTest {
    private AttributeInOIDCRequestedClaimsMatcher matcher;
    private ProfileRequestContext prc;
    private MessageContext msgCtx;
    private OIDCMetadataContext ctx;
    IdPAttribute attribute;
    AttributeFilterContext filtercontext;

    private void setUp(boolean idtoken, boolean userinfo) throws Exception {
        this.matcher = new AttributeInOIDCRequestedClaimsMatcher();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.msgCtx = new MessageContext();
        this.prc.setInboundMessageContext(this.msgCtx);
        this.prc.setOutboundMessageContext(this.msgCtx);
        OIDCAuthenticationResponseContext respCtx = new OIDCAuthenticationResponseContext();
        this.msgCtx.addSubcontext((BaseContext)respCtx);
        if (!idtoken && !userinfo) {
            this.msgCtx.setMessage((Object)new AuthenticationRequest(new URI("htts://example.org"), ResponseType.getDefault(), new Scope(new String[]{"openid"}), new ClientID(), new URI("htts://example.org"), new State(), new Nonce()));
        } else {
            this.msgCtx.setMessage((Object)new AuthenticationRequest(new URI("htts://example.org"), ResponseType.getDefault(), null, new Scope(new String[]{"openid"}), new ClientID(), new URI("htts://example.org"), new State(), new Nonce(), null, null, 0, null, null, null, null, null, this.getClaimsRequest(idtoken, userinfo), null, null, null, null, null, null, userinfo, null));
            respCtx.setRequestedClaims(this.getClaimsRequest(idtoken, userinfo));
            this.setMappedClaims(respCtx, idtoken, userinfo);
        }
        this.filtercontext = (AttributeFilterContext)this.prc.getSubcontext(AttributeFilterContext.class, true);
        this.ctx = new OIDCMetadataContext();
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        OIDCClientInformation information = new OIDCClientInformation(new ClientID(), new Date(), metadata, new Secret());
        this.ctx.setClientInformation(information);
        this.msgCtx.addSubcontext((BaseContext)this.ctx);
        this.attribute = new IdPAttribute("test");
        this.matcher.setId("componentId");
    }

    private void setMappedClaims(OIDCAuthenticationResponseContext respCtx, boolean idtoken, boolean userinfo) {
        HashMultimap map = HashMultimap.create();
        map.put((Object)"any", (Object)new IdPRequestedAttribute("any"));
        if (idtoken || userinfo) {
            map.put((Object)"test", (Object)new IdPRequestedAttribute("test"));
        }
        if (idtoken) {
            respCtx.setMappedIdTokenRequestedClaims(new AttributesMapContainer((Multimap)map));
        }
        if (userinfo) {
            respCtx.setMappedUserinfoRequestedClaims(new AttributesMapContainer((Multimap)map));
        }
    }

    private OIDCClaimsRequest getClaimsRequest(boolean idtoken, boolean userinfo) {
        ClaimsSetRequest idTokenClaims = new ClaimsSetRequest().add("any");
        ClaimsSetRequest userInfoClaims = new ClaimsSetRequest().add("any");
        if (idtoken) {
            idTokenClaims = idTokenClaims.add("test");
        }
        if (userinfo) {
            userInfoClaims = userInfoClaims.add("test");
        }
        return new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaims).withUserInfoClaimsRequest(userInfoClaims);
    }

    @Test
    public void testNoEncoders() throws Exception {
        this.setUp(false, false);
        this.matcher.initialize();
        Set result = this.matcher.getMatchingValues(this.attribute, this.filtercontext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void testFailNoMsgCtx() throws Exception {
        this.setUp(false, false);
        this.matcher.initialize();
        this.prc.setOutboundMessageContext(null);
        Assert.assertNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }

    @Test
    public void testFailNoOidcMsgCtx() throws Exception {
        this.setUp(false, false);
        this.matcher.initialize();
        this.prc.getOutboundMessageContext().removeSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }

    @Test
    public void testNoClaims() throws Exception {
        this.setUp(false, false);
        this.matcher.initialize();
        Set result = this.matcher.getMatchingValues(this.attribute, this.filtercontext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void testNoClaimsSilent() throws Exception {
        this.setUp(false, false);
        this.matcher.setMatchIfRequestedClaimsSilent(true);
        this.matcher.initialize();
        Set result = this.matcher.getMatchingValues(this.attribute, this.filtercontext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void testAnyMatchIdToken() throws Exception {
        this.setUp(true, false);
        this.matcher.initialize();
        Assert.assertNotNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }

    @Test
    public void testAnyMatchUserInfo() throws Exception {
        this.setUp(false, true);
        this.matcher.initialize();
        Assert.assertNotNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }

    @Test
    public void testIdTokenMatchFail() throws Exception {
        this.setUp(false, true);
        this.matcher.setMatchOnlyIDToken(true);
        this.matcher.initialize();
        Set result = this.matcher.getMatchingValues(this.attribute, this.filtercontext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void testUserInfoMatchFail() throws Exception {
        this.setUp(true, false);
        this.matcher.setMatchOnlyUserInfo(true);
        this.matcher.initialize();
        Set result = this.matcher.getMatchingValues(this.attribute, this.filtercontext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void testIdTokenMatch() throws Exception {
        this.setUp(true, false);
        this.matcher.setMatchOnlyIDToken(true);
        this.matcher.initialize();
        Assert.assertNotNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }

    @Test
    public void testUserInfoMatch() throws Exception {
        this.setUp(false, true);
        this.matcher.setMatchOnlyUserInfo(true);
        this.matcher.initialize();
        Assert.assertNotNull((Object)this.matcher.getMatchingValues(this.attribute, this.filtercontext));
    }
}

