/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.admin.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.plugin.oidc.op.admin.impl.IssueRegistrationAccessToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.AccessControl;
import net.shibboleth.utilities.java.support.security.AccessControlService;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IssueRegistrationAccessTokenTest {
    private IssueRegistrationAccessToken action;
    private RequestContext requestCtx;
    private ProfileRequestContext prc;
    private DataSealer dataSealer;
    private ObjectMapper objectMapper;
    private AccessControlService accessControlService;
    private String issuer = "mockIssuer";
    private String relyingPartyId = "tokenRpId";
    private String clientId = "mockClient";
    private String lifetime = "P1D";
    private MockHttpServletRequest httpRequest;
    private MockHttpServletResponse httpResponse;

    @BeforeClass
    public void initOnce() {
        this.accessControlService = new MockAccessControlService();
    }

    @BeforeMethod
    public void init() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.dataSealer = BaseOIDCResponseActionTest.initializeDataSealer();
        this.objectMapper = new ObjectMapper();
        this.action = new IssueRegistrationAccessToken();
        this.action.setObjectMapper(this.objectMapper);
        this.action.setMetadataPolicyLookupStrategy(FunctionSupport.constant(this.defaultMetadataPolicy()));
        this.action.setSealer(this.dataSealer);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setPolicyLocationPolicyName("policyLocationPolicy");
        this.action.setPolicyIdPolicyName("policyIdPolicy");
        this.action.setClientIdPolicyName("clientIdPolicy");
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.initRequestResponse();
        this.action.initialize();
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
    }

    protected void initRequestResponse() {
        this.httpRequest = new MockHttpServletRequest();
        this.action.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.httpResponse = new MockHttpServletResponse();
        this.action.setHttpServletResponse((HttpServletResponse)this.httpResponse);
    }

    protected Map<String, MetadataPolicy> defaultMetadataPolicy() {
        HashMap<String, MetadataPolicy> policy = new HashMap<String, MetadataPolicy>();
        policy.put("claim1", new MetadataPolicy.Builder().withAdd((Object)"addValue").build());
        return policy;
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoSealer() throws ComponentInitializationException {
        this.action = new IssueRegistrationAccessToken();
        this.action.setObjectMapper(this.objectMapper);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setMetadataPolicyLookupStrategy(FunctionSupport.constant(this.defaultMetadataPolicy()));
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoObjectMapper() throws ComponentInitializationException {
        this.action = new IssueRegistrationAccessToken();
        this.action.setSealer(this.dataSealer);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setMetadataPolicyLookupStrategy(FunctionSupport.constant(this.defaultMetadataPolicy()));
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoMetadataPolicyLookup() throws ComponentInitializationException {
        this.action = new IssueRegistrationAccessToken();
        this.action.setSealer(this.dataSealer);
        this.action.setObjectMapper(this.objectMapper);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.action.initialize();
    }

    @Test
    public void testNoMetadataPolicyNorId() throws ComponentInitializationException, JsonMappingException, JsonProcessingException, UnsupportedEncodingException {
        this.action = new IssueRegistrationAccessToken();
        this.action.setSealer(this.dataSealer);
        this.action.setObjectMapper(this.objectMapper);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setMetadataPolicyLookupStrategy(FunctionSupport.constant(null));
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.initRequestResponse();
        this.action.initialize();
        this.requestCtx.getFlowScope().put("tokenLifetime", (Object)this.lifetime);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        this.assertErrorResponse(400, "Invalid Request");
    }

    @Test
    public void testInvalidMetadataPolicyLocation() throws ComponentInitializationException, JsonMappingException, JsonProcessingException, UnsupportedEncodingException {
        this.action = new IssueRegistrationAccessToken();
        this.action.setSealer(this.dataSealer);
        this.action.setObjectMapper(this.objectMapper);
        this.action.setAccessControlService(this.accessControlService);
        this.action.setPolicyLocationLookupStrategy(FunctionSupport.constant((Object)"not_existing_location"));
        this.action.setMetadataPolicyLookupStrategy(FunctionSupport.constant(null));
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)this.issuer));
        this.initRequestResponse();
        this.action.initialize();
        this.requestCtx.getFlowScope().put("tokenLifetime", (Object)this.lifetime);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        this.assertErrorResponse(400, "Invalid Request");
    }

    @Test
    public void testNoTokenLifetime() throws DataSealerException, JsonMappingException, JsonProcessingException {
        this.requestCtx.getFlowScope().put("policyId", (Object)this.relyingPartyId);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.validateToken(this.relyingPartyId, null);
    }

    @Test
    public void testSuccessNoPolicyId() throws DataSealerException, JsonMappingException, JsonProcessingException {
        this.requestCtx.getFlowScope().put("tokenLifetime", (Object)this.lifetime);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.validateToken(null, null);
    }

    @Test
    public void testSuccessWithPolicyId() throws DataSealerException, JsonMappingException, JsonProcessingException {
        this.requestCtx.getFlowScope().put("tokenLifetime", (Object)this.lifetime);
        this.requestCtx.getFlowScope().put("policyId", (Object)this.relyingPartyId);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.validateToken(this.relyingPartyId, null);
    }

    @Test
    public void testSuccessWithClientIdPolicyId() throws DataSealerException, JsonMappingException, JsonProcessingException {
        this.requestCtx.getFlowScope().put("tokenLifetime", (Object)this.lifetime);
        this.requestCtx.getFlowScope().put("policyId", (Object)this.relyingPartyId);
        this.requestCtx.getFlowScope().put("clientId", (Object)this.clientId);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        this.validateToken(this.relyingPartyId, this.clientId);
    }

    protected void validateToken(String policyId, String clientId) throws DataSealerException, JsonMappingException, JsonProcessingException {
        Instant start = Instant.now();
        Object rawMessage = this.prc.getOutboundMessageContext().getMessage();
        Assert.assertNotNull((Object)rawMessage);
        Assert.assertTrue((boolean)(rawMessage instanceof AccessTokenResponse));
        AccessTokenResponse tokenResponse = (AccessTokenResponse)rawMessage;
        Assert.assertNotNull((Object)tokenResponse.getTokens());
        BearerAccessToken accessToken = tokenResponse.getTokens().getBearerAccessToken();
        Assert.assertNotNull((Object)accessToken);
        String decryptedToken = this.dataSealer.unwrap(accessToken.getValue());
        RegistrationClaimsSet claimsSet = (RegistrationClaimsSet)this.objectMapper.readValue(decryptedToken, RegistrationClaimsSet.class);
        Assert.assertEquals((String)claimsSet.getKeyType(), (String)"rt");
        Assert.assertNotNull((Object)claimsSet.getJti());
        Assert.assertEquals((String)claimsSet.getIssuer(), (String)this.issuer);
        Assert.assertEquals((String)claimsSet.getRelyingPartyId(), (String)policyId);
        Assert.assertEquals((String)claimsSet.getClientId(), (String)clientId);
        Map tokenPolicy = claimsSet.getMetadata();
        Assert.assertNotNull((Object)tokenPolicy);
        Assert.assertEquals((int)tokenPolicy.size(), (int)1);
        Assert.assertTrue((boolean)tokenPolicy.containsKey("claim1"));
        MetadataPolicy claimPolicy = (MetadataPolicy)tokenPolicy.get("claim1");
        Assert.assertEquals((Object)claimPolicy.getAdd(), (Object)"addValue");
        this.assertInstantWithSkew(claimsSet.getIssuedAt(), start);
        this.assertInstantWithSkew(claimsSet.getExpiration(), start.plus(Duration.ofDays(1L)));
    }

    protected void assertInstantWithSkew(Instant instant, Instant target) {
        Duration skew = Duration.ofSeconds(5L);
        Assert.assertTrue((boolean)instant.isAfter(target.minus(skew)));
        Assert.assertTrue((boolean)instant.isBefore(target.plus(skew)));
    }

    protected void assertErrorResponse(int status, String title) throws UnsupportedEncodingException, JsonMappingException, JsonProcessingException {
        Assert.assertEquals((int)this.httpResponse.getStatus(), (int)status);
        String rawResponse = this.httpResponse.getContentAsString();
        ObjectMapper objectMapper = new ObjectMapper();
        Errors errors = (Errors)objectMapper.readerFor(Errors.class).readValue(rawResponse);
        Assert.assertNotNull((Object)errors);
        Assert.assertNotNull((Object)errors.getErrors());
        Assert.assertEquals((int)errors.getErrors().size(), (int)1);
        Error error = (Error)errors.getErrors().get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((String)error.getStatus(), (String)("" + status));
        Assert.assertEquals((String)error.getTitle(), (String)title);
    }

    private class MockAccessControlService
    implements AccessControlService {
        private MockAccessControlService() {
        }

        public boolean isInitialized() {
            return true;
        }

        public void initialize() throws ComponentInitializationException {
        }

        public String getId() {
            return "mockACS";
        }

        public AccessControl getInstance(final String name) {
            return new AccessControl(){

                public boolean checkAccess(ServletRequest request, String operation, String resource) {
                    if ("read".equals(operation)) {
                        return "policyIdPolicy".equals(name) && IssueRegistrationAccessTokenTest.this.relyingPartyId.equals(resource);
                    }
                    return "write".equals(operation) && "clientIdPolicy".equals(name) && IssueRegistrationAccessTokenTest.this.clientId.equals(resource);
                }
            };
        }
    }
}

