/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetResponseStatusCodeFromEvent
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetResponseStatusCodeFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    @Nullable
    private Map<String, Integer> mappedErrors = new HashMap<String, Integer>();
    private int defaultCode = 500;

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setDefaultCode(int code) {
        this.defaultCode = code;
    }

    public void setMappedErrors(@Nonnull Map<String, Integer> errors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mappedErrors = (Map)Constraint.isNotNull(errors, (String)"Mapped errors cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.error("{} No event to be included in the response, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        String event = eventCtx.getEvent().toString();
        if (this.mappedErrors.containsKey(event)) {
            this.log.debug("{} Found mapped event for {}", (Object)this.getLogPrefix(), (Object)event);
            this.getHttpServletResponse().setStatus(this.mappedErrors.get(event).intValue());
        } else {
            this.log.debug("{} No mapping found for {}, default status code {} set", new Object[]{this.getLogPrefix(), event, this.defaultCode});
            this.getHttpServletResponse().setStatus(this.defaultCode);
        }
    }
}

