/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRemainingClaimsToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRemainingClaimsToClientMetadata.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> registrationMetadataPolicyContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationMetadataPolicyContext.class, false).compose((Function)new InboundMessageContextLookup());
    @Nullable
    private Map<String, MetadataPolicy> metadataPolicy;

    public void setRegistrationMetadataPolicyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registrationMetadataPolicyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Registration metadata policy context lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCClientRegistrationMetadataPolicyContext metadataPolicyContext = this.registrationMetadataPolicyContextLookupStrategy.apply(profileRequestContext);
        if (metadataPolicyContext == null) {
            this.log.debug("{} No OIDCClientRegistrationMetadataPolicyContext found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.metadataPolicy = metadataPolicyContext.getMetadataPolicy();
        if (this.metadataPolicy == null || this.metadataPolicy.isEmpty()) {
            this.log.debug("{} No metadata policy found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JSONObject input = this.getInputMetadata().toJSONObject();
        JSONObject initialOutput = this.getOutputMetadata().toJSONObject();
        for (String claim : input.keySet()) {
            if (initialOutput.containsKey((Object)claim)) continue;
            if (this.metadataPolicy.containsKey(claim)) {
                this.log.debug("{} added {} to the output metadata", (Object)this.getLogPrefix(), (Object)claim);
                this.getOutputMetadata().setCustomField(claim, input.get((Object)claim));
                continue;
            }
            this.log.warn("{} input contained claim {} that is not recognized and is thus ignored", (Object)this.getLogPrefix(), (Object)claim);
        }
    }
}

