/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCSigningResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAccessTokenHashToIDToken
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAccessTokenHashToIDToken.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        if (this.getOidcResponseContext().getAccessToken() == null) {
            this.log.error("{} No access token to calculate hash on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AccessTokenHash atHash = AccessTokenHash.compute((AccessToken)this.getOidcResponseContext().getAccessToken(), (JWSAlgorithm)new JWSAlgorithm(this.getSignatureSigningParameters().getSignatureAlgorithm()), null);
        if (atHash == null || atHash.getValue() == null) {
            this.log.error("{} Not able to generate at_hash using algorithm {}", (Object)this.getLogPrefix(), (Object)this.getSignatureSigningParameters().getSignatureAlgorithm());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        this.log.debug("{} Setting access token hash to id token", (Object)this.getLogPrefix());
        this.getOidcResponseContext().getIDToken().setClaim("at_hash", (Object)atHash.getValue());
        this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getIDToken().toJSONObject().toJSONString());
    }
}

