/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.cli;

import com.beust.jcommander.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractCommandLineArguments;

public class IssueRegistrationAccessTokenArguments
extends AbstractCommandLineArguments {
    public static final String URL_PARAM_POLICY_LOCATION = "policyLocation";
    public static final String URL_PARAM_LIFETIME = "tokenLifetime";
    public static final String URL_PARAM_POLICY_ID = "policyId";
    public static final String URL_PARAM_CLIENT_ID = "clientId";
    public static final String URL_PARAM_REPLACEMENT = "replacement";
    @Parameter(names={"-loc", "--policyLocation"}, required=false, description="Metadata policy location")
    @Nullable
    private String policyLocation;
    @Parameter(names={"-l", "--lifetime"}, required=false, description="Lifetime for the access token")
    @Nullable
    private String lifetime;
    @Parameter(names={"-id", "--policyId"}, required=false, description="Metadata policy ID")
    @Nullable
    private String policyId;
    @Parameter(names={"-c", "--clientId"}, required=false, description="Client ID to request in the access token")
    @Nullable
    private String clientId;
    @Parameter(names={"-r", "--replacement"}, required=false, description="Flag to request the ability to re-register the same client ID for the life of the token")
    @Nullable
    private boolean replacement;

    public void validate() {
        if (this.policyLocation == null && this.policyId == null) {
            throw new IllegalArgumentException("One of policyLocation or policyId is required");
        }
        if (this.clientId == null && this.replacement) {
            throw new IllegalArgumentException("Enabling replacement requires specifying a client ID");
        }
    }

    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        if (this.getPath() == null) {
            builder.append("/profile/admin/oidc/issue-registration-access-token");
        }
        try {
            if (this.policyLocation != null) {
                this.appendSeparator(builder).append("policyLocation=").append(URLEncoder.encode(this.policyLocation, "UTF-8"));
            }
            if (this.policyId != null) {
                this.appendSeparator(builder).append("policyId=").append(URLEncoder.encode(this.policyId, "UTF-8"));
            }
            if (this.lifetime != null) {
                builder.append("&tokenLifetime=").append(URLEncoder.encode(this.lifetime, "UTF-8"));
            }
            if (this.clientId != null) {
                builder.append("&clientId=").append(URLEncoder.encode(this.clientId, "UTF-8"));
                if (this.replacement) {
                    builder.append("&replacement=" + this.replacement);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URL encoding failed", e);
        }
        return builder;
    }

    @Nonnull
    private StringBuilder appendSeparator(@Nonnull StringBuilder builder) {
        if (builder.toString().contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        return builder;
    }
}

