/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInfoAudienceLookupFunction
implements ContextDataLookupFunction<OIDCMetadataContext, List<String>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ClientInfoAudienceLookupFunction.class);
    @Nullable
    @NonnullElements
    private List<String> defaultAudience;

    public void setDefaultAudience(@Nullable @NonnullElements Collection<String> audience) {
        this.defaultAudience = List.copyOf(StringSupport.normalizeStringCollection(audience));
    }

    @Nullable
    @NonnullElements
    public List<String> apply(@Nullable OIDCMetadataContext input) {
        if (input == null || input.getClientInformation() == null) {
            return this.defaultAudience;
        }
        Object obj = input.getClientInformation().getMetadata().getCustomField("audience");
        if (obj instanceof Collection) {
            ArrayList<String> audience = new ArrayList<String>();
            for (Object val : (Collection)obj) {
                if (val instanceof String) {
                    audience.add((String)val);
                    continue;
                }
                if (!(val instanceof URI)) continue;
                audience.add(val.toString());
            }
            return audience;
        }
        if (obj instanceof String) {
            return Collections.singletonList((String)obj);
        }
        return null;
    }
}

