/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.RefreshableMetadataValueResolver;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DynamicFilesystemProviderMetadataResolver
extends FilesystemProviderMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(DynamicFilesystemProviderMetadataResolver.class);
    private Map<String, ? extends MetadataValueResolver> dynamicResolvers = new HashMap<String, MetadataValueResolver>();

    public DynamicFilesystemProviderMetadataResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public DynamicFilesystemProviderMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    public void setDynamicValueResolvers(Map<String, ? extends MetadataValueResolver> map) {
        this.dynamicResolvers = (Map)Constraint.isNotNull(map, (String)"The map of dynamic metadata resolvers cannot be null");
    }

    @Override
    public Iterable<OIDCProviderMetadata> resolve(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ArrayList<OIDCProviderMetadata> result = new ArrayList<OIDCProviderMetadata>();
        for (OIDCProviderMetadata entity : super.resolve(profileRequestContext)) {
            JSONObject entityJson = entity.toJSONObject();
            for (String key : this.dynamicResolvers.keySet()) {
                this.log.debug("Starting to resolve value for {}", (Object)key);
                MetadataValueResolver resolver = this.dynamicResolvers.get(key);
                try {
                    Object value;
                    if (resolver instanceof RefreshableMetadataValueResolver) {
                        ((RefreshableMetadataValueResolver)resolver).refresh();
                    }
                    if ((value = resolver.resolveSingle((Object)profileRequestContext)) == null) continue;
                    entityJson.put((Object)key, value);
                    this.log.debug("The field {} updated to the result", (Object)key);
                }
                catch (ResolverException e) {
                    this.log.warn("Could not resolve a value for {\u031b}, ignoring it.", (Object)key, (Object)e);
                }
            }
            try {
                result.add(OIDCProviderMetadata.parse((JSONObject)entityJson));
            }
            catch (ParseException e) {
                this.log.warn("The resulting provider metadata is not valid, ignoring it", (Throwable)e);
            }
        }
        return result;
    }

    protected Instant getMetadataUpdateTime() {
        Instant updateTime = super.getMetadataUpdateTime();
        for (String id : this.dynamicResolvers.keySet()) {
            MetadataValueResolver resolver = this.dynamicResolvers.get(id);
            if (!(resolver instanceof RefreshableMetadataValueResolver)) continue;
            if (((RefreshableMetadataValueResolver)resolver).getLastUpdate() == null) {
                return Instant.now();
            }
            if (!((RefreshableMetadataValueResolver)resolver).getLastUpdate().isAfter(updateTime)) continue;
            return ((RefreshableMetadataValueResolver)resolver).getLastUpdate();
        }
        return updateTime;
    }
}

