/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.storage;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.commons.codec.digest.DigestUtils;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="3.1.0", forRemoval=true)
@ThreadSafeAfterInit
public class RevocationCache
extends AbstractIdentifiableInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(RevocationCache.class);
    private StorageService storage;
    private boolean strict;
    @Nonnull
    @Positive
    private Duration expires = Duration.ofHours(6L);

    public void setEntryExpiration(@Positive Duration entryExpiration) {
        Constraint.isTrue((entryExpiration != null && !entryExpiration.isNegative() && !entryExpiration.isZero() ? 1 : 0) != 0, (String)"Revocation cache entry expiration must be greater than 0");
        this.expires = entryExpiration;
    }

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storage = (StorageService)Constraint.isNotNull((Object)storageService, (String)"StorageService cannot be null");
        StorageCapabilities caps = this.storage.getCapabilities();
        if (caps instanceof StorageCapabilitiesEx) {
            Constraint.isTrue((boolean)((StorageCapabilitiesEx)caps).isServerSide(), (String)"StorageService cannot be client-side");
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.strict = flag;
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
    }

    public synchronized boolean revoke(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return false;
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Entry '{}' of context '{}'\u00a0is not yet on list of revoked entries, adding to cache with expiration time {}", new Object[]{key, context, this.expires});
                this.storage.create(context, key, "y", Long.valueOf(Instant.now().plus(this.expires).toEpochMilli()));
                return true;
            }
            this.storage.update(context, key, "y", Long.valueOf(Instant.now().plus(this.expires).toEpochMilli()));
            this.log.debug("Entry '{}' of context '{}' was already revoked, updating expiration", (Object)key, (Object)context);
            return true;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service, returning {}", (Object)(this.strict ? "failure" : "success"), (Object)e);
            return !this.strict;
        }
    }

    public synchronized boolean isRevoked(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s) {
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return true;
        }
        String key = s.length() > caps.getKeySize() ? DigestUtils.sha1Hex((String)s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Entry '{}' is not revoked", (Object)key);
                return false;
            }
            this.log.debug("Entry '{}' is revoked", (Object)s);
            return true;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service, returning {}", (Object)(this.strict ? "failure" : "success"), (Object)e);
            return !this.strict;
        }
    }
}

