/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.sdk.impl;

import com.duosecurity.Client;
import com.duosecurity.exception.DuoException;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Token;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheckResponse;
import net.shibboleth.oidc.security.impl.JWSAssemblyUtils;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public final class DuoSDKClientAdaptor
extends AbstractDuoOIDCClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoSDKClientAdaptor.class);
    @Nonnull
    private final Client client;
    @Nonnull
    private final Function<HealthCheckResponse, DuoHealthCheck> healthCheckResponseConverter;
    @Nonnull
    private final BiFunction<Token, DuoOIDCIntegration, JWT> tokenResponseConverter;
    @Nonnull
    private final DuoOIDCIntegration duoIntegration;

    DuoSDKClientAdaptor(@Nonnull DuoOIDCIntegration integration, @Nullable List<String> caCerts) throws DuoClientException {
        this.duoIntegration = (DuoOIDCIntegration)Constraint.isNotNull((Object)integration, (String)"Duo SDK Client requires a non-null Duo Integration");
        this.healthCheckResponseConverter = new DefaultHealthCheckResponseConverter();
        this.tokenResponseConverter = new DefaultTokenResponseConverter();
        try {
            this.client = caCerts == null ? new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), integration.getRedirectURI()).setUseDuoCodeAttribute(false).build() : new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), integration.getRedirectURI()).setCACerts(caCerts.toArray(new String[caCerts.size()])).setUseDuoCodeAttribute(false).build();
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public DuoHealthCheck healthCheck() throws DuoClientException {
        try {
            HealthCheckResponse response = this.client.healthCheck();
            if (response == null) {
                throw new DuoClientException("Duo health check response was null");
            }
            return this.healthCheckResponseConverter.apply(response);
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public String createAuthUrl(@Nonnull @NotEmpty String username, @Nonnull @NotEmpty String state, @Nullable String nonce, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)username, (String)"Username can not be null or empty");
        Constraint.isNotEmpty((String)state, (String)"State can not be null or empty");
        try {
            return this.client.createAuthUrl(username, state);
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public JWT exchangeAuthorizationCodeFor2FAResult(@Nonnull String code, @Nonnull String username, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)code, (String)"Auth_code can not be null");
        try {
            Token token = this.client.exchangeAuthorizationCodeFor2FAResult(code, username);
            if (token == null) {
                throw new DuoClientException("Duo token was null");
            }
            JWT tokenAsJWT = this.tokenResponseConverter.apply(token, this.duoIntegration);
            if (tokenAsJWT == null) {
                throw new DuoClientException("Duo token could not be converted to a JWT");
            }
            return tokenAsJWT;
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    public boolean isSupportsNonce() {
        return false;
    }

    @ThreadSafe
    private final class DefaultTokenResponseConverter
    implements BiFunction<Token, DuoOIDCIntegration, JWT> {
        @Nonnull
        private ObjectMapper objectMapper = new ObjectMapper();

        private DefaultTokenResponseConverter() {
        }

        @Override
        @Nullable
        public JWT apply(@Nonnull Token t, @Nonnull DuoOIDCIntegration integ) {
            try {
                String duoTokenAsJson = this.objectMapper.writeValueAsString((Object)t);
                JWTClaimsSet claims = JWTClaimsSet.parse((String)duoTokenAsJson);
                return JWSAssemblyUtils.assembleMacJws((JWSAlgorithm)JWSAlgorithm.HS512, (JWTClaimsSet)claims, (byte[])JWSAssemblyUtils.getSecretBytes((String)integ.getSecretKey()));
            }
            catch (JsonProcessingException | JOSEException | ParseException | EncodingException e) {
                DuoSDKClientAdaptor.this.log.error("Could not convert Duo Token to a Nimbus JWT Token", e);
                return null;
            }
        }
    }

    @ThreadSafe
    private class DefaultHealthCheckResponseConverter
    implements Function<HealthCheckResponse, DuoHealthCheck> {
        private DefaultHealthCheckResponseConverter() {
        }

        @Override
        public DuoHealthCheck apply(@Nonnull HealthCheckResponse response) {
            return DuoHealthCheck.builder().withStatus(response.getStat()).withCode(response.getCode()).withMessage(response.getMessage()).withMessageDetail(response.getMessage_detail()).withResponse(new DuoHealthCheckResponse(response.getResponse().getTimestamp())).withTimestamp(response.getTimestamp()).build();
        }
    }
}

