/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.sdk.impl;

import java.util.ArrayList;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.sdk.impl.DuoSDKClientFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DuoSDKClientFactoryTest {
    private DuoSDKClientFactory factory;

    @BeforeMethod
    public void setUp() throws Exception {
        this.factory = new DuoSDKClientFactory();
    }

    @Test
    public final void testSetNullCaCerts() {
        this.factory.setCaCerts(null);
    }

    @Test
    public final void testSetCaCerts() {
        ArrayList<String> certs = new ArrayList<String>();
        certs.add("sha256/I/Lt/z7ekCWanjD0Cvj5EqXls2lOaThEA0H2Bg4BT/o=");
        this.factory.setCaCerts(certs);
    }

    @Test
    public final void testCreateInstance() throws DuoClientException {
        ArrayList<String> certs = new ArrayList<String>();
        certs.add("sha256/I/Lt/z7ekCWanjD0Cvj5EqXls2lOaThEA0H2Bg4BT/o=");
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setAPIHost("api-c9f24c5a.duosecurity.com");
        integ.setClientId("DIU6GEFWG5LIUTVV2M3N");
        integ.setRegisteredRedirectURI("http://localhost/");
        integ.setSecretKey("TeXvZxKul47v1Wew2zb6xRPzAJewJ34MP2w8Uith");
        integ.setAuthorizeEndpoint("/oauth/v1/authorize");
        integ.setTokenEndpoint("/oauth/v1/token");
        integ.setHealthCheckEndpoint("/oauth/v1/health_check");
        integ.setRedirectURIIfAbsent(integ.getRegisteredRedirectURI());
        DuoOIDCClient client = this.factory.createInstance((DuoOIDCIntegration)integ);
        Assert.assertNotNull((Object)client);
    }
}

