/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoAuthenticationAction;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.impl.JWSAssemblyUtils;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateTokenSignature
extends AbstractDuoAuthenticationAction {
    @Nonnull
    private static final JWSAlgorithm.Family SUPPORTED_SIGNATURE_FAMILY = JWSAlgorithm.Family.HMAC_SHA;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateTokenSignature.class);
    @Nonnull
    private Algorithm signatureAlgorithm = JWSAlgorithm.HS512;
    @Nullable
    private JWT token;
    @Nullable
    private JWTClaimsSet claimSet;
    @Nullable
    private DuoOIDCIntegration integration;

    public void setSignatureAlgorithm(@Nonnull JWSAlgorithm algo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)algo, (String)"Signature algorithm can not be null");
        if (!SUPPORTED_SIGNATURE_FAMILY.contains((Object)algo)) {
            throw new ConstraintViolationException("Signature algorithm must be one of " + SUPPORTED_SIGNATURE_FAMILY);
        }
        this.signatureAlgorithm = algo;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        this.token = duoContext.getAuthToken();
        if (this.token == null) {
            this.log.error("{} Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        try {
            this.claimSet = this.token.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.error("{} Claimset of Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        this.integration = duoContext.getIntegration();
        if (this.integration == null) {
            this.log.error("{} Duo integration is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        this.log.debug("{} Validating token signature for subject '{}'", (Object)this.getLogPrefix(), (Object)this.claimSet.getSubject());
        if (this.token instanceof PlainJWT || JWSAlgorithm.NONE == this.token.getHeader().getAlgorithm()) {
            this.log.error("{} Invalid token signature for subject '{}'. Token must be signed using one of the supported algorithms '{}'", new Object[]{this.getLogPrefix(), this.claimSet.getSubject(), SUPPORTED_SIGNATURE_FAMILY});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        if (this.token instanceof SignedJWT) {
            BasicJWKCredential jwkCredential = new BasicJWKCredential();
            jwkCredential.setSecretKey((SecretKey)new SecretKeySpec(JWSAssemblyUtils.getSecretBytes((String)this.integration.getSecretKey()), "NONE"));
            jwkCredential.setAlgorithm(this.signatureAlgorithm);
            String errorEventId = JWTSignatureValidationUtil.validateSignature(List.of(jwkCredential), (SignedJWT)((SignedJWT)this.token), (String)"NoCredentials");
            if (errorEventId != null) {
                this.log.error("{} Token signature is invalid for subject '{}' and client '{}'", new Object[]{this.getLogPrefix(), this.claimSet.getSubject(), this.integration.getClientId()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
                return;
            }
            this.log.debug("{} Token signature is valid for subject '{}'; using algorithm '{}' for client '{}'", new Object[]{this.getLogPrefix(), this.claimSet.getSubject(), this.signatureAlgorithm, this.integration.getClientId()});
            return;
        }
        this.log.error("{} Unable to validate token signature for subject '{}' and client '{}', unkown token type", new Object[]{this.getLogPrefix(), this.claimSet.getSubject(), this.integration.getClientId()});
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
    }
}

