/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.HealthCheckDuoOIDCAuthAPI;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_FAIL;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_OK;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClient_UNKNOWN;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

class HealthCheckDuoOIDCAuthAPITest
extends AbstractDuoActionTest {
    private HealthCheckDuoOIDCAuthAPI healthCheckAction;

    HealthCheckDuoOIDCAuthAPITest() {
    }

    @BeforeMethod
    public void setUp() throws Exception {
        super.setup();
        this.healthCheckAction = new HealthCheckDuoOIDCAuthAPI();
    }

    @Test
    void testDoExecuteHealthy() throws DuoRegistryException, ComponentInitializationException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_OK(this.dc.getIntegration()));
        this.healthCheckAction.initialize();
        Event event = this.healthCheckAction.execute(this.src);
        Assert.assertNull((Object)event);
    }

    @Test
    void testDoExecuteUnHealthy() throws DuoRegistryException, ComponentInitializationException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_FAIL(this.dc.getIntegration()));
        this.healthCheckAction.initialize();
        Event event = this.healthCheckAction.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }

    @Test
    void testDoExecuteUnknown() throws DuoRegistryException, ComponentInitializationException, DuoClientException {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        this.dc.setClient((DuoOIDCClient)new MockDuoOIDCClient_UNKNOWN(this.dc.getIntegration()));
        this.healthCheckAction.initialize();
        Event event = this.healthCheckAction.execute(this.src);
        this.assertEventId(event, "AuthenticationException");
    }
}

