/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoActionTest;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoAudienceClaimLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DuoAudienceClaimLookupStrategyTest
extends AbstractDuoActionTest {
    @Nonnull
    private DuoAudienceClaimLookupStrategy strategy;

    @BeforeMethod
    public void beforeMethod() throws ComponentInitializationException {
        super.setup();
        this.strategy = new DuoAudienceClaimLookupStrategy();
    }

    @Test
    public void applySuccess() {
        this.addDuoContext();
        this.addDuoIntegrationToContext();
        String audience = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)audience, (String)this.dc.getIntegration().getClientId());
    }

    @Test
    public void applyNoDuoContext() {
        String audience = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)audience, null);
    }

    @Test
    public void applyNoDuoIntegration() {
        this.addDuoContext();
        String audience = this.strategy.apply(this.prc, new JWTClaimsSet.Builder().build());
        Assert.assertEquals((String)audience, null);
    }
}

