/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.idp.plugin.authn.duo.impl.DefaultDuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.mock.MockDuoOIDCClientFactory_OK_Client;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultDuoOIDCClientRegistryTest {
    private DefaultDuoOIDCClientRegistry registry;

    @BeforeMethod
    public void setUp() throws Exception {
        this.registry = new DefaultDuoOIDCClientRegistry();
        this.registry.setId("Test registry");
    }

    @Test
    public final void testCaching() throws DuoRegistryException, ComponentInitializationException {
        MockDuoOIDCClientFactory_OK_Client factory = new MockDuoOIDCClientFactory_OK_Client();
        this.registry.setClientFactory((DuoOIDCClientFactory)factory);
        this.registry.initialize();
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setAPIHost("host.com");
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setRegisteredRedirectURI("http://localhost/");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        DuoOIDCClient client = this.registry.getClientOrCreate((DuoOIDCIntegration)integ);
        DuoOIDCClient clientTwo = this.registry.getClientOrCreate((DuoOIDCIntegration)integ);
        Assert.assertEquals((Object)client, (Object)clientTwo);
        integ.setClientId("DIU6GEFWG5LIUBVV2M3B");
        DuoOIDCClient clientThree = this.registry.getClientOrCreate((DuoOIDCIntegration)integ);
        System.out.println("Client: " + client + " Client2: " + clientTwo + " Client3: " + clientThree);
        Assert.assertNotSame((Object)client, (Object)clientThree);
    }

    @Test(expectedExceptions={DuoRegistryException.class})
    public final void testClientFailedToCreate() throws DuoRegistryException, ComponentInitializationException, DuoClientException {
        DuoOIDCClientFactory mockClientFactory = (DuoOIDCClientFactory)Mockito.mock(DuoOIDCClientFactory.class);
        Mockito.when((Object)mockClientFactory.createInstance((DuoOIDCIntegration)ArgumentMatchers.any(DuoOIDCIntegration.class))).thenThrow(DuoClientException.class);
        this.registry.setClientFactory(mockClientFactory);
        this.registry.initialize();
        DuoOIDCClient client = this.registry.getClientOrCreate((DuoOIDCIntegration)Mockito.mock(DuoOIDCIntegration.class));
    }

    public final void testThreadSafetyCaching() throws Exception {
        MockDuoOIDCClientFactory_OK_Client factory = new MockDuoOIDCClientFactory_OK_Client();
        this.registry.setClientFactory((DuoOIDCClientFactory)factory);
        this.registry.initialize();
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setAPIHost("host.com");
        integ.setClientId("DIU6GEFWG5LIUBVV2M3P");
        integ.setRegisteredRedirectURI("http://localhost/");
        integ.setSecretKey("rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh");
        ExecutorService service = Executors.newFixedThreadPool(2);
        ArrayList<Future<DuoOIDCClient>> futures = new ArrayList<Future<DuoOIDCClient>>(2);
        for (int t = 0; t < 2; ++t) {
            futures.add(service.submit(() -> this.registry.getClientOrCreate((DuoOIDCIntegration)integ)));
        }
        for (Future future : futures) {
            DuoOIDCClient client = (DuoOIDCClient)future.get();
            System.out.println("client:" + client);
        }
    }
}

