/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DefaultDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;

public abstract class AbstractDuoActionTest {
    protected static final String CLIENT_ID = "DIU6GEFWG5LIUBVV2M3P";
    protected static final String REDIRECT_URI = "http://localhost/";
    protected static final String API_HOST = "api.duosecurity.com";
    protected static final String AUTHORIZE_URI = "/authorize";
    protected static final String TOKEN_URI = "/token";
    protected static final String HEALTH_URI = "/health";
    protected static final String SECRET = "rFvDfPul27v3Wew2zb6xRPzAJewJ34MP2w8UitPh";
    protected RequestContext src;
    protected ProfileRequestContext prc;
    protected AuthenticationContext ac;
    protected DuoOIDCAuthenticationContext dc;

    public void setup() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.ac = new AuthenticationContext();
        this.prc.addSubcontext((BaseContext)this.ac);
    }

    protected JWT createPlainDummyToken(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJson(authResult, authResultMessage, aud, exp, iat, authTime, apiHost, factor);
        try {
            PlainJWT jwt = new PlainJWT(new PlainHeader().toBase64URL(), new Base64URL(Base64Support.encodeURLSafe((byte[])jwtJson.getBytes())));
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException | EncodingException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createPlainDummyTokenNoAuthResult(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJsonWithNoAuthResult(authResult, authResultMessage, aud, exp, iat, authTime, apiHost, factor);
        try {
            PlainJWT jwt = new PlainJWT(new PlainHeader().toBase64URL(), new Base64URL(Base64Support.encodeURLSafe((byte[])jwtJson.getBytes())));
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException | EncodingException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createPlainDummyToken(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJsonMissingAudAndExpClaims(authResult, authResultMessage, iat, authTime, apiHost, factor);
        try {
            PlainJWT jwt = new PlainJWT(new PlainHeader().toBase64URL(), new Base64URL(Base64Support.encodeURLSafe((byte[])jwtJson.getBytes())));
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException | EncodingException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createPlainDummyToken(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull Instant nbf, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJsonWithNbf(authResult, authResultMessage, aud, exp, iat, authTime, nbf, apiHost, factor);
        try {
            PlainJWT jwt = new PlainJWT(new PlainHeader().toBase64URL(), new Base64URL(Base64Support.encodeURLSafe((byte[])jwtJson.getBytes())));
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException | EncodingException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createSignedDummyToken(@Nonnull String headerJson, @Nonnull String secret, @Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJson(authResult, authResultMessage, aud, exp, iat, authTime, apiHost, factor);
        try {
            MACSigner signer = new MACSigner(secret);
            JWSHeader header = JWSHeader.parse((String)headerJson);
            JWTClaimsSet claims = JWTClaimsSet.parse((String)jwtJson);
            SignedJWT jwt = new SignedJWT(header, claims);
            jwt.sign((JWSSigner)signer);
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (JOSEException | ParseException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createSignedDummyTokenFromGivenSignature(@Nonnull String headerJson, @Nonnull String signatureBase64, @Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJson(authResult, authResultMessage, aud, exp, iat, authTime, apiHost, factor);
        try {
            SignedJWT jwt = new SignedJWT(new Base64URL(Base64Support.encodeURLSafe((byte[])headerJson.getBytes())), new Base64URL(Base64Support.encodeURLSafe((byte[])jwtJson.getBytes())), new Base64URL(signatureBase64));
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException | EncodingException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    protected JWT createUnsignedSignedDummyToken(@Nonnull String headerJson, @Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = this.createJWTJson(authResult, authResultMessage, aud, exp, iat, authTime, apiHost, factor);
        try {
            JWSHeader header = JWSHeader.parse((String)headerJson);
            JWTClaimsSet claims = JWTClaimsSet.parse((String)jwtJson);
            SignedJWT jwt = new SignedJWT(header, claims);
            jwt.getJWTClaimsSet();
            return jwt;
        }
        catch (ParseException e) {
            Assert.fail((String)"Error creating the Mock JWT", (Throwable)e);
            Assert.fail();
            return null;
        }
    }

    private String createJWTJson(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = "{\n    \"iss\": \"https://" + apiHost + "/oauth/v1/token\",\n    \"sub\": \"jdoe\",\n    \"preferred_username\": \"jdoe\",\n    \"aud\": \"" + aud + "\",\n    \"exp\": " + Math.toIntExact(exp.getEpochSecond()) + ",\n    \"iat\": " + (double)iat.getEpochSecond() + ",\n    \"auth_time\": " + authTime.getEpochSecond() + ",\n    \"auth_result\": {\n        \"status_msg\": \"" + authResultMessage + "\",\n        \"status\": \"" + authResult + "\",\n        \"result\": \"" + authResult + "\"\n    },\n    \"auth_context\": {\n        \"result\": \"success\",\n        \"timestamp\": 1599749128,\n        \"auth_device\": {\n            \"ip\": \"1.1.1.1\",\n            \"name\": \"+44 999999\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"txid\": \"1684599c-bb16-4250-af85-904291bfe7cc\",\n        \"event_type\": \"authentication\",\n        \"reason\": \"user_approved\",\n        \"access_device\": {\n            \"hostname\": null,\n            \"ip\": \"1.1.1.1\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"application\": {\n            \"key\": \"DIU6GEFWG5LIUTVV2M3N\",\n            \"name\": \"Shibboleth Integration Testing\"\n        },\n        \"factor\": \"" + factor + "\",\n        \"user\": {\n            \"key\": \"DUGL8U46QGJSOUJWG59W\",\n            \"name\": \"jdoe\"\n        }\n    }\n}";
        return jwtJson;
    }

    private String createJWTJsonWithNoAuthResult(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = "{\n    \"iss\": \"https://" + apiHost + "/oauth/v1/token\",\n    \"sub\": \"jdoe\",\n    \"preferred_username\": \"jdoe\",\n    \"aud\": \"" + aud + "\",\n    \"exp\": " + Math.toIntExact(exp.getEpochSecond()) + ",\n    \"iat\": " + (double)iat.getEpochSecond() + ",\n    \"auth_time\": " + authTime.getEpochSecond() + ",\n    \"auth_context\": {\n        \"result\": \"success\",\n        \"timestamp\": 1599749128,\n        \"auth_device\": {\n            \"ip\": \"1.1.1.1\",\n            \"name\": \"+44 999999\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"txid\": \"1684599c-bb16-4250-af85-904291bfe7cc\",\n        \"event_type\": \"authentication\",\n        \"reason\": \"user_approved\",\n        \"access_device\": {\n            \"hostname\": null,\n            \"ip\": \"1.1.1.1\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"application\": {\n            \"key\": \"DIU6GEFWG5LIUTVV2M3N\",\n            \"name\": \"Shibboleth Integration Testing\"\n        },\n        \"factor\": \"" + factor + "\",\n        \"user\": {\n            \"key\": \"DUGL8U46QGJSOUJWG59W\",\n            \"name\": \"jdoe\"\n        }\n    }\n}";
        return jwtJson;
    }

    private String createJWTJsonMissingAudAndExpClaims(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = "{\n    \"iss\": \"https://" + apiHost + "/oauth/v1/token\",\n    \"sub\": \"jdoe\",\n    \"preferred_username\": \"jdoe\",\n    \"iat\": " + (double)iat.getEpochSecond() + ",\n    \"auth_time\": " + authTime.getEpochSecond() + ",\n    \"auth_result\": {\n        \"status_msg\": \"" + authResultMessage + "\",\n        \"status\": \"" + authResult + "\",\n        \"result\": \"" + authResult + "\"\n    },\n    \"auth_context\": {\n        \"result\": \"success\",\n        \"timestamp\": 1599749128,\n        \"auth_device\": {\n            \"ip\": \"1.1.1.1\",\n            \"name\": \"+44 999999\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"txid\": \"1684599c-bb16-4250-af85-904291bfe7cc\",\n        \"event_type\": \"authentication\",\n        \"reason\": \"user_approved\",\n        \"access_device\": {\n            \"hostname\": null,\n            \"ip\": \"1.1.1.1\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"application\": {\n            \"key\": \"DIU6GEFWG5LIUTVV2M3N\",\n            \"name\": \"Shibboleth Integration Testing\"\n        },\n        \"factor\": \"" + factor + "\",\n        \"user\": {\n            \"key\": \"DUGL8U46QGJSOUJWG59W\",\n            \"name\": \"jdoe\"\n        }\n    }\n}";
        return jwtJson;
    }

    private String createJWTJsonWithNbf(@Nonnull String authResult, @Nonnull String authResultMessage, @Nonnull String aud, @Nonnull Instant exp, @Nonnull Instant iat, @Nonnull Instant authTime, @Nonnull Instant nbf, @Nonnull String apiHost, @Nonnull String factor) {
        String jwtJson = "{\n    \"nbf\": " + Math.toIntExact(nbf.getEpochSecond()) + ",\n    \"iss\": \"https://" + apiHost + "/oauth/v1/token\",\n    \"sub\": \"jdoe\",\n    \"preferred_username\": \"jdoe\",\n    \"aud\": \"" + aud + "\",\n    \"exp\": " + Math.toIntExact(exp.getEpochSecond()) + ",\n    \"iat\": " + (double)iat.getEpochSecond() + ",\n    \"auth_time\": " + authTime.getEpochSecond() + ",\n    \"auth_result\": {\n        \"status_msg\": \"" + authResultMessage + "\",\n        \"status\": \"" + authResult + "\",\n        \"result\": \"" + authResult + "\"\n    },\n    \"auth_context\": {\n        \"result\": \"success\",\n        \"timestamp\": 1599749128,\n        \"auth_device\": {\n            \"ip\": \"1.1.1.1\",\n            \"name\": \"+44 999999\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"txid\": \"1684599c-bb16-4250-af85-904291bfe7cc\",\n        \"event_type\": \"authentication\",\n        \"reason\": \"user_approved\",\n        \"access_device\": {\n            \"hostname\": null,\n            \"ip\": \"1.1.1.1\",\n            \"location\": {\n                \"state\": \"State\",\n                \"city\": \"City\",\n                \"country\": \"Country\"\n            }\n        },\n        \"application\": {\n            \"key\": \"DIU6GEFWG5LIUTVV2M3N\",\n            \"name\": \"Shibboleth Integration Testing\"\n        },\n        \"factor\": \"" + factor + "\",\n        \"user\": {\n            \"key\": \"DUGL8U46QGJSOUJWG59W\",\n            \"name\": \"jdoe\"\n        }\n    }\n}";
        return jwtJson;
    }

    protected void addAttemptedFlow(@Nonnull String flowId) {
        Assert.assertNotNull((Object)flowId);
        AuthenticationFlowDescriptor afd = new AuthenticationFlowDescriptor();
        afd.setId(flowId);
        this.ac.setAttemptedFlow(afd);
    }

    protected void assertEventIdFromProfileRequestContext(@Nonnull String eventId) {
        Object event = ((EventContext)this.prc.getSubcontext(EventContext.class, true)).getEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event instanceof String), (String)("Event is not a string is: " + event.getClass()));
        Assert.assertEquals((String)eventId, (String)((String)event));
    }

    protected void assertEventId(@Nullable Event event, @Nonnull String eventId) {
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)event.getId(), (String)eventId);
    }

    protected void addDuoContext() {
        this.dc = new DuoOIDCAuthenticationContext();
        this.dc.setUsername("jdoe");
        this.ac.addSubcontext((BaseContext)this.dc);
    }

    protected void addDuoIntegrationToContext() {
        Assert.assertNotNull((Object)this.dc, (String)"try addDuoContext() before adding the duo integration");
        this.dc.setIntegration((DuoOIDCIntegration)this.createDummyDuoIntegration());
    }

    @Nonnull
    protected DefaultDuoOIDCIntegration createDummyDuoIntegration() {
        DefaultDuoOIDCIntegration integ = new DefaultDuoOIDCIntegration();
        integ.setAPIHost(API_HOST);
        integ.setClientId(CLIENT_ID);
        integ.setRegisteredRedirectURI(REDIRECT_URI);
        integ.setSecretKey(SECRET);
        integ.setAuthorizeEndpoint(AUTHORIZE_URI);
        integ.setTokenEndpoint(TOKEN_URI);
        integ.setHealthCheckEndpoint(HEALTH_URI);
        return integ;
    }
}

