/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.spring.CustomAbstractXmlFlowExecutionTests;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.mock.env.MockPropertySource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.config.FlowDefinitionResourceFactory;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowBuilderContext;

public abstract class AbstractAuthnXmlFlowExecutionTests
extends CustomAbstractXmlFlowExecutionTests {
    protected MockHttpServletRequest mockRequest;
    protected MockHttpServletResponse mockResponse;
    protected MockExternalContext externalContext;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAuthnXmlFlowExecutionTests.class);
    @Nonnull
    private String flowPath;
    @Nonnull
    private Map<String, String> flowModelResources = Collections.emptyMap();
    @Nonnull
    private List<Flow> subflows = Collections.emptyList();
    @Nonnull
    private Map<String, String> mockProperties = Collections.emptyMap();
    @Nullable
    private DuoOIDCClientFactory clientFactory;
    private boolean removeDefaultContextCleanupHook = false;

    public void setFlowModelResources(@Nonnull Map<String, String> testFlowModelResources) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(testFlowModelResources);
        this.flowModelResources = testFlowModelResources;
    }

    public void setClientFactory(@Nonnull DuoOIDCClientFactory factory) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)factory);
        this.clientFactory = factory;
    }

    public void setFlowPath(@Nonnull @NotEmpty String testFlowPath) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)testFlowPath);
        this.flowPath = testFlowPath;
    }

    public void setMockProperties(@Nonnull Map<String, String> properties) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(properties);
        this.mockProperties = properties;
    }

    public void setSubflows(@Nonnull @NonnullElements List<Flow> mockSubflows) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull(mockSubflows);
        this.subflows = mockSubflows;
    }

    public void addHttpBasicAuthHeader(@Nonnull String username, @Nonnull String password) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)username);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)password);
        this.mockRequest.addHeader("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes())));
    }

    public void setUp() throws NoSuchFieldException, SecurityException, Exception {
        this.mockRequest = new MockHttpServletRequest();
        this.mockResponse = new MockHttpServletResponse();
        this.externalContext = new MockExternalContext();
        this.externalContext.setNativeRequest((Object)this.mockRequest);
        this.externalContext.setNativeResponse((Object)this.mockResponse);
        this.removeDefaultContextCleanupHook = false;
    }

    protected FlowDefinitionResource getResource(FlowDefinitionResourceFactory resourceFactory) {
        return resourceFactory.createClassPathResource(this.flowPath, ((Object)((Object)this)).getClass());
    }

    @Override
    protected FlowDefinitionResource[] getModelResources(FlowDefinitionResourceFactory resourceFactory) {
        if (!this.flowModelResources.isEmpty()) {
            FlowDefinitionResource[] resources = new FlowDefinitionResource[this.flowModelResources.size()];
            int rIndex = 0;
            for (Map.Entry<String, String> entry : this.flowModelResources.entrySet()) {
                resources[rIndex++] = resourceFactory.createResource(entry.getKey(), null, entry.getValue());
            }
            return resources;
        }
        return null;
    }

    protected void configureFlowBuilderContext(MockFlowBuilderContext builderContext) {
        this.registerMockBeanDefinitions(builderContext);
        this.registerMockPropertySource(builderContext);
        this.registerMockSubflows(builderContext);
    }

    private void registerMockSubflows(@Nonnull MockFlowBuilderContext builderContext) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        this.subflows.forEach(flow -> builderContext.registerSubflow(flow));
    }

    private void registerMockBeanDefinitions(@Nonnull MockFlowBuilderContext builderContext) {
        builderContext.registerBean("shibboleth.DefaultIdentifierGenerationStrategy", (Object)new SecureRandomIdentifierGenerationStrategy());
        builderContext.registerBean("shibboleth.HttpServletRequest", (Object)this.mockRequest);
        builderContext.registerBean("shibboleth.HttpServletResponse", (Object)this.mockResponse);
        builderContext.registerBean("shibboleth.PostLoginSubjectCanonicalizationFlows", Collections.emptyList());
        builderContext.registerBean("shibboleth.JSONObjectMapper", (Object)new ObjectMapper());
        ConversionServiceFactoryBean conversationService = new ConversionServiceFactoryBean();
        Converter<String, Duration> durationConverter = new Converter<String, Duration>(){

            public Duration convert(String source) {
                if (source.startsWith("P") || source.startsWith("-P")) {
                    return DOMTypeSupport.stringToDuration((String)source.trim());
                }
                return Duration.ofMillis(Long.valueOf(source));
            }
        };
        conversationService.setConverters(Set.of(durationConverter));
        conversationService.afterPropertiesSet();
        builderContext.registerBean("conversionService", (Object)conversationService.getObject());
        this.addBeanDefinition(builderContext, "shibboleth.Functions.Constant", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FunctionSupport.class).setFactoryMethod("constant").setAbstract(true).getBeanDefinition());
        if (this.clientFactory != null) {
            builderContext.registerBean("shibboleth.authn.DuoOIDC.test.clientFactory", (Object)this.clientFactory);
        }
        if (this.isRemoveDefaultContextCleanupHook()) {
            builderContext.registerBean("shibboleth.authn.DuoOIDC.CleanUpHook", (Object)new Consumer<ProfileRequestContext>(){

                @Override
                public void accept(ProfileRequestContext t) {
                }
            });
        }
    }

    private void addBeanDefinition(@Nonnull MockFlowBuilderContext builderContext, @Nonnull String beanName, @Nonnull BeanDefinition bean) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)beanName);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)bean);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(builderContext.getApplicationContext() instanceof ConfigurableApplicationContext));
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)builderContext.getApplicationContext()).getBeanFactory();
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)factory);
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(factory instanceof DefaultListableBeanFactory));
        ((DefaultListableBeanFactory)factory).registerBeanDefinition(beanName, bean);
    }

    private void registerMockPropertySource(@Nonnull MockFlowBuilderContext builderContext) {
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext);
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext.getApplicationContext());
        AbstractAuthnXmlFlowExecutionTests.assertNotNull((Object)builderContext.getApplicationContext().getEnvironment());
        AbstractAuthnXmlFlowExecutionTests.assertTrue((boolean)(builderContext.getApplicationContext().getEnvironment() instanceof StandardEnvironment));
        MockPropertySource mock = new MockPropertySource();
        mock.setProperty("idp.home", (Object)"classpath:");
        mock.setProperty("idp.webflows", (Object)"classpath*:/flows");
        this.mockProperties.forEach((key, value) -> mock.setProperty(key, value));
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).getPropertySources().addFirst((PropertySource)mock);
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).setPlaceholderPrefix("%{");
        ((StandardEnvironment)builderContext.getApplicationContext().getEnvironment()).setPlaceholderSuffix("}");
    }

    @Nonnull
    protected ProfileRequestContext buildProfileRequestContext(@Nonnull boolean forceAuthn, @Nonnull boolean addC14Context) {
        ProfileRequestContext prc = new ProfileRequestContext();
        AuthenticationContext ac = new AuthenticationContext();
        AuthenticationFlowDescriptor afd = new AuthenticationFlowDescriptor();
        afd.setId("authn/DuoOIDC");
        ac.setAttemptedFlow(afd);
        ac.addSubcontext((BaseContext)new RelyingPartyUIContext());
        ac.setForceAuthn(forceAuthn);
        prc.addSubcontext((BaseContext)ac);
        if (addC14Context) {
            SubjectCanonicalizationContext scc = new SubjectCanonicalizationContext();
            scc.setPrincipalName("jdoe");
            prc.addSubcontext((BaseContext)scc);
        }
        SessionContext sc = new SessionContext();
        IdPSession session = (IdPSession)Mockito.mock(IdPSession.class);
        Mockito.when((Object)session.getPrincipalName()).thenReturn((Object)"jdoe");
        sc.setIdPSession(session);
        prc.addSubcontext((BaseContext)sc);
        prc.setBrowserProfile(true);
        return prc;
    }

    protected boolean isRemoveDefaultContextCleanupHook() {
        return this.removeDefaultContextCleanupHook;
    }

    protected void setRemoveDefaultContextCleanupHook(boolean removeDefaultContextCleanupHook) {
        this.removeDefaultContextCleanupHook = removeDefaultContextCleanupHook;
    }
}

