/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.time.Duration;
import java.util.Collections;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.idp.session.impl.DestroySessions;
import net.shibboleth.idp.session.impl.testing.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DestroySessionsTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private DestroySessions action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new DestroySessions();
        this.action.setSessionManager((SessionManager)this.sessionManager);
        this.action.initialize();
    }

    @Override
    protected void adjustProperties() throws ComponentInitializationException {
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        this.sessionManager.setSessionSlop(Duration.ofSeconds(900L));
        SPSessionSerializerRegistry registry = new SPSessionSerializerRegistry();
        registry.setMappings(Collections.singletonMap(BasicSPSession.class, new BasicSPSessionSerializer(Duration.ofSeconds(900L))));
        registry.initialize();
        this.sessionManager.setSPSessionSerializerRegistry(registry);
    }

    @Test
    public void testNoContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testNoSessions() {
        this.prc.getSubcontext(LogoutContext.class, true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testOneSessionNoUnbind() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        String sessionId = session.getId();
        ((LogoutContext)this.prc.getSubcontext(LogoutContext.class, true)).getIdPSessions().add(session);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertTrue((boolean)logoutCtx.getIdPSessions().isEmpty());
        session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionId)}));
        Assert.assertNull((Object)session);
    }

    @Test
    public void testOneSessionUnbind() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        String sessionId = session.getId();
        ((LogoutContext)this.prc.getSubcontext(LogoutContext.class, true)).getIdPSessions().add(session);
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertTrue((boolean)logoutCtx.getIdPSessions().isEmpty());
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNull((Object)sessionCtx);
        session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionId)}));
        Assert.assertNull((Object)session);
    }

    @Test
    public void testOneSessionDifferent() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        ((LogoutContext)this.prc.getSubcontext(LogoutContext.class, true)).getIdPSessions().add(session);
        cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertTrue((boolean)logoutCtx.getIdPSessions().isEmpty());
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertNotNull((Object)sessionCtx.getIdPSession());
    }

    @Test
    public void testTwoSessions() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        ((LogoutContext)this.prc.getSubcontext(LogoutContext.class, true)).getIdPSessions().add(session);
        cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        ((LogoutContext)this.prc.getSubcontext(LogoutContext.class, true)).getIdPSessions().add(session);
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertTrue((boolean)logoutCtx.getIdPSessions().isEmpty());
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNull((Object)sessionCtx);
    }
}

