/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.session.AbstractIdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.impl.StorageBackedIdPSession;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StorageBackedIdPSessionSerializer
extends AbstractInitializableComponent
implements StorageSerializer<StorageBackedIdPSession> {
    @Nonnull
    @NotEmpty
    private static final String CREATION_INSTANT_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "nam";
    @Nonnull
    @NotEmpty
    private static final String IPV4_ADDRESS_FIELD = "v4";
    @Nonnull
    @NotEmpty
    private static final String IPV6_ADDRESS_FIELD = "v6";
    @Nonnull
    @NotEmpty
    private static final String FLOW_ID_ARRAY_FIELD = "flows";
    @Nonnull
    @NotEmpty
    private static final String SERVICE_ID_ARRAY_FIELD = "svcs";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageBackedIdPSessionSerializer.class);
    @Nonnull
    private final StorageBackedSessionManager sessionManager;
    @Nullable
    private final StorageBackedIdPSession targetObject;
    @Nonnull
    private final JsonProvider jsonProvider;

    public StorageBackedIdPSessionSerializer(@Nonnull StorageBackedSessionManager manager, @Nullable StorageBackedIdPSession target) {
        this.sessionManager = (StorageBackedSessionManager)((Object)Constraint.isNotNull((Object)((Object)manager), (String)"SessionManager cannot be null"));
        this.targetObject = target;
        this.jsonProvider = JsonProvider.provider();
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull StorageBackedIdPSession instance) throws IOException {
        try {
            Set<AuthenticationResult> results;
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = this.jsonProvider.createGenerator((Writer)sink);
            gen.writeStartObject().write(CREATION_INSTANT_FIELD, instance.getCreationInstant()).write(PRINCIPAL_NAME_FIELD, instance.getPrincipalName());
            if (instance.getAddress(AbstractIdPSession.AddressFamily.IPV4) != null) {
                gen.write(IPV4_ADDRESS_FIELD, instance.getAddress(AbstractIdPSession.AddressFamily.IPV4));
            }
            if (instance.getAddress(AbstractIdPSession.AddressFamily.IPV6) != null) {
                gen.write(IPV6_ADDRESS_FIELD, instance.getAddress(AbstractIdPSession.AddressFamily.IPV6));
            }
            if (!(results = instance.getAuthenticationResults()).isEmpty()) {
                gen.writeStartArray(FLOW_ID_ARRAY_FIELD);
                for (AuthenticationResult result : results) {
                    gen.write(result.getAuthenticationFlowId());
                }
                gen.writeEnd();
            }
            if (this.sessionManager.isTrackSPSessions()) {
                if (this.sessionManager.storageServiceMeetsThreshold()) {
                    Set<SPSession> services = instance.getSPSessions();
                    if (!services.isEmpty()) {
                        gen.writeStartArray(SERVICE_ID_ARRAY_FIELD);
                        for (SPSession service : services) {
                            gen.write(service.getId());
                        }
                        gen.writeEnd();
                    }
                } else {
                    this.log.debug("Unable to serialize SP session due to to storage service limitations");
                }
            }
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing IdPSession", (Throwable)e);
            throw new IOException("Exception while serializing IdPSession", e);
        }
    }

    @Nonnull
    public StorageBackedIdPSession deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        if (expiration == null) {
            throw new IOException("IdPSession objects must have an expiration");
        }
        try {
            JsonArray svcIds;
            JsonArray flowIds;
            JsonReader reader = this.jsonProvider.createReader((Reader)new StringReader(value));
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing IdPSession");
            }
            JsonObject obj = (JsonObject)st;
            StorageBackedIdPSession objectToPopulate = this.targetObject;
            if (objectToPopulate == null) {
                long creation = obj.getJsonNumber(CREATION_INSTANT_FIELD).longValueExact();
                String principalName = obj.getString(PRINCIPAL_NAME_FIELD);
                objectToPopulate = new StorageBackedIdPSession(this.sessionManager, context, principalName, creation);
            }
            objectToPopulate.setVersion(version);
            objectToPopulate.doSetLastActivityInstant(expiration - this.sessionManager.getSessionTimeout() - this.sessionManager.getSessionSlop());
            if (obj.containsKey((Object)IPV4_ADDRESS_FIELD)) {
                objectToPopulate.doBindToAddress(obj.getString(IPV4_ADDRESS_FIELD));
            }
            if (obj.containsKey((Object)IPV6_ADDRESS_FIELD)) {
                objectToPopulate.doBindToAddress(obj.getString(IPV6_ADDRESS_FIELD));
            }
            objectToPopulate.getAuthenticationResultMap().clear();
            if (obj.containsKey((Object)FLOW_ID_ARRAY_FIELD) && (flowIds = obj.getJsonArray(FLOW_ID_ARRAY_FIELD)) != null) {
                for (JsonString flowId : flowIds.getValuesAs(JsonString.class)) {
                    objectToPopulate.getAuthenticationResultMap().put(flowId.getString(), (Optional<AuthenticationResult>)Optional.absent());
                }
            }
            objectToPopulate.getSPSessionMap().clear();
            if (obj.containsKey((Object)SERVICE_ID_ARRAY_FIELD) && (svcIds = obj.getJsonArray(SERVICE_ID_ARRAY_FIELD)) != null) {
                for (JsonString svcId : svcIds.getValuesAs(JsonString.class)) {
                    objectToPopulate.getSPSessionMap().put(svcId.getString(), (Optional<SPSession>)Optional.absent());
                }
            }
            return objectToPopulate;
        }
        catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
            this.log.error("Exception while parsing IdPSession", e);
            throw new IOException("Found invalid data structure while parsing IdPSession", e);
        }
    }
}

