/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLogout
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessLogout.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddressCondition = Predicates.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextCreationStrategy = new ChildContextLookup(SubjectContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextCreationStrategy = new ChildContextLookup(LogoutContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = new Function<ProfileRequestContext, CriteriaSet>(){

        public CriteriaSet apply(ProfileRequestContext input) {
            return new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()});
        }
    };

    public void setCheckAddressCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.checkAddressCondition = (Predicate)Constraint.isNotNull(condition, (String)"Address checking condition cannot be null");
    }

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSubjectContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext creation strategy cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext creation strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals((Object)Predicates.alwaysFalse())) {
            if (this.sessionResolver == null) {
                throw new ComponentInitializationException("SessionResolver cannot be null");
            }
            if (this.sessionManager == null) {
                throw new ComponentInitializationException("SessionManager cannot be null");
            }
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            LogoutContext logoutCtx;
            SessionContext sessionCtx;
            IdPSession session;
            block15: {
                session = (IdPSession)this.sessionResolver.resolveSingle(this.sessionResolverCriteriaStrategy.apply((Object)profileRequestContext));
                if (session == null) {
                    this.log.info("{} No active session found matching current request", (Object)this.getLogPrefix());
                    return;
                }
                if (this.checkAddressCondition.apply((Object)profileRequestContext)) {
                    HttpServletRequest request = this.getHttpServletRequest();
                    if (request != null && request.getRemoteAddr() != null) {
                        try {
                            if (!session.checkAddress(request.getRemoteAddr())) {
                                return;
                            }
                            break block15;
                        }
                        catch (SessionException e) {
                            this.log.error("{} Error binding session to client address", (Object)this.getLogPrefix(), (Object)e);
                            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
                            return;
                        }
                    }
                    this.log.info("{} No servlet request or client address available, skipping address check for sessions", (Object)this.getLogPrefix());
                } else {
                    this.log.debug("{} Bypassing address check for session {}", (Object)this.getLogPrefix(), (Object)session.getId());
                }
            }
            SubjectContext subjectCtx = (SubjectContext)this.subjectContextCreationStrategy.apply((Object)profileRequestContext);
            if (subjectCtx != null) {
                subjectCtx.setPrincipalName(session.getPrincipalName());
            }
            if ((sessionCtx = (SessionContext)this.sessionContextCreationStrategy.apply((Object)profileRequestContext)) != null) {
                sessionCtx.setIdPSession(session);
            }
            if ((logoutCtx = (LogoutContext)this.logoutContextCreationStrategy.apply((Object)profileRequestContext)) == null) {
                this.log.error("{} Unable to create or locate LogoutContext", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            int count = 1;
            for (SPSession spSession : session.getSPSessions()) {
                logoutCtx.getSessionMap().put((Object)spSession.getId(), (Object)spSession);
                logoutCtx.getKeyedSessionMap().put(Integer.toString(count++), spSession);
            }
            try {
                this.sessionManager.destroySession(session.getId(), true);
            }
            catch (SessionException e) {
                this.log.error("{} Error destroying session", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving matching session(s)", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

