/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.MultiRelyingPartyContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateMultiRPContextFromLogoutContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    private static final String LABEL = "logout";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateMultiRPContextFromLogoutContext.class);
    @NonnullAfterInit
    private RoleDescriptorResolver metadataResolver;
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);
    @Nonnull
    private Map<Class<? extends SPSession>, String> sessionTypeProtocolMap = Collections.emptyMap();
    @NonnullAfterInit
    private QName role = SPSSODescriptor.DEFAULT_ELEMENT_NAME;
    @Nullable
    private LogoutContext logoutCtx;

    public void setRoleDescriptorResolver(@Nonnull RoleDescriptorResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = (RoleDescriptorResolver)Constraint.isNotNull((Object)resolver, (String)"RoleDescriptorResolver cannot be null");
    }

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext lookup strategy cannot be null");
    }

    public void setSessionTypeProtocolMap(@Nonnull Map<Class<? extends SPSession>, String> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Session type to protocol map cannot be null");
        this.sessionTypeProtocolMap = new HashMap<Class<? extends SPSession>, String>(map.size());
        for (Map.Entry<Class<? extends SPSession>, String> entry : map.entrySet()) {
            String trimmed;
            if (entry.getKey() == null || (trimmed = StringSupport.trimOrNull((String)entry.getValue())) == null) continue;
            this.sessionTypeProtocolMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRole(@Nonnull QName theRole) {
        this.role = (QName)Constraint.isNotNull((Object)theRole, (String)"Role cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.logoutCtx = (LogoutContext)this.logoutContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.logoutCtx == null) {
            this.log.debug("{} No LogoutContext found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        MultiRelyingPartyContext multiCtx = new MultiRelyingPartyContext();
        profileRequestContext.addSubcontext((BaseContext)multiCtx, true);
        for (String relyingPartyId : this.logoutCtx.getSessionMap().keySet()) {
            RelyingPartyContext rpCtx = new RelyingPartyContext();
            rpCtx.setRelyingPartyId(relyingPartyId);
            multiCtx.addRelyingPartyContext(LABEL, rpCtx);
            EntityIdCriterion entityIdCriterion = new EntityIdCriterion(rpCtx.getRelyingPartyId());
            EntityRoleCriterion roleCriterion = new EntityRoleCriterion(this.role);
            ProtocolCriterion protocolCriterion = null;
            SPSession spSession = (SPSession)this.logoutCtx.getSessions(relyingPartyId).iterator().next();
            String protocol = this.sessionTypeProtocolMap.get(spSession.getClass());
            if (protocol != null) {
                protocolCriterion = new ProtocolCriterion(protocol);
            }
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{entityIdCriterion, protocolCriterion, roleCriterion});
            try {
                RoleDescriptor roleMetadata = (RoleDescriptor)this.metadataResolver.resolveSingle((Object)criteria);
                if (roleMetadata == null) {
                    if (protocolCriterion != null) {
                        this.log.info("{} No metadata returned for {} in role {} with protocol {}", new Object[]{this.getLogPrefix(), entityIdCriterion.getEntityId(), this.role, protocol});
                        continue;
                    }
                    this.log.info("{} No metadata returned for {} in role {}", new Object[]{this.getLogPrefix(), entityIdCriterion.getEntityId(), this.role});
                    continue;
                }
                SAMLMetadataContext metadataCtx = (SAMLMetadataContext)rpCtx.getSubcontext(SAMLMetadataContext.class, true);
                metadataCtx.setEntityDescriptor((EntityDescriptor)roleMetadata.getParent());
                metadataCtx.setRoleDescriptor(roleMetadata);
                this.log.debug("{} SAMLMetadataContext added to RelyingPartyContext for {}", (Object)this.getLogPrefix(), (Object)rpCtx.getRelyingPartyId());
            }
            catch (ResolverException e) {
                this.log.error("{} ResolverException thrown during metadata lookup", (Object)this.getLogPrefix(), (Object)e);
            }
        }
    }
}

